/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.message;

import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.dcp.message.StreamFlags;

public enum DcpAddStreamRequest {


    public static boolean is(ByteBuf buffer) {
        return buffer.getByte(0) == -128 && buffer.getByte(1) == 81;
    }

    public static int flags(ByteBuf buffer) {
        return MessageUtil.getExtras(buffer).getInt(0);
    }

    public static boolean takeover(ByteBuf buffer) {
        return StreamFlags.TAKEOVER.isSet(DcpAddStreamRequest.flags(buffer));
    }

    public static boolean diskOnly(ByteBuf buffer) {
        return StreamFlags.DISK_ONLY.isSet(DcpAddStreamRequest.flags(buffer));
    }

    public static boolean latest(ByteBuf buffer) {
        return StreamFlags.LATEST.isSet(DcpAddStreamRequest.flags(buffer));
    }

    public static boolean noValue(ByteBuf buffer) {
        return StreamFlags.NO_VALUE.isSet(DcpAddStreamRequest.flags(buffer));
    }

    public static boolean activeVbucketOnly(ByteBuf buffer) {
        return StreamFlags.ACTIVE_VB_ONLY.isSet(DcpAddStreamRequest.flags(buffer));
    }

    public static boolean strictVbucketUuid(ByteBuf buffer) {
        return StreamFlags.STRICT_VB_UUID.isSet(DcpAddStreamRequest.flags(buffer));
    }

    public static void init(ByteBuf buffer) {
        MessageUtil.initRequest((byte)81, buffer);
        DcpAddStreamRequest.flags(buffer, 0);
    }

    public static void flags(ByteBuf buffer, int flags) {
        ByteBuf extras = Unpooled.buffer(4);
        MessageUtil.setExtras(extras.writeInt(flags), buffer);
        extras.release();
    }
}

