/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.message;

import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.dcp.message.MessageUtil;

public enum DcpBufferAckRequest {


    public static boolean is(ByteBuf buffer) {
        return buffer.getByte(0) == -128 && buffer.getByte(1) == 93;
    }

    public static void init(ByteBuf buffer) {
        MessageUtil.initRequest((byte)93, buffer);
    }

    public static void opaque(ByteBuf buffer, int opaque) {
        MessageUtil.setOpaque(opaque, buffer);
    }

    public static void ackBytes(ByteBuf buffer, int bytes) {
        ByteBuf extras = Unpooled.buffer(4);
        MessageUtil.setExtras(extras.writeInt(bytes), buffer);
        extras.release();
    }
}

