/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.message;

import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.message.MessageUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public enum DcpDeletionMessage {


    public static boolean is(ByteBuf buffer) {
        return buffer.getByte(0) == -128 && buffer.getByte(1) == 88;
    }

    @Deprecated
    public static ByteBuf key(ByteBuf buffer) {
        return MessageUtil.getKey(buffer);
    }

    @Deprecated
    public static String keyString(ByteBuf buffer, Charset charset) {
        return DcpDeletionMessage.key(buffer).toString(charset);
    }

    @Deprecated
    public static String keyString(ByteBuf buffer) {
        return DcpDeletionMessage.keyString(buffer, StandardCharsets.UTF_8);
    }

    public static long cas(ByteBuf buffer) {
        return MessageUtil.getCas(buffer);
    }

    public static short partition(ByteBuf buffer) {
        return MessageUtil.getVbucket(buffer);
    }

    public static long bySeqno(ByteBuf buffer) {
        return buffer.getLong(24);
    }

    public static long revisionSeqno(ByteBuf buffer) {
        return buffer.getLong(32);
    }

    public static String toString(ByteBuf buffer) {
        return "DeletionMessage [key: \"" + DcpDeletionMessage.keyString(buffer) + "\", vbid: " + DcpDeletionMessage.partition(buffer) + ", cas: " + DcpDeletionMessage.cas(buffer) + ", bySeqno: " + DcpDeletionMessage.bySeqno(buffer) + ", revSeqno: " + DcpDeletionMessage.revisionSeqno(buffer) + "]";
    }
}

