/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.message;

import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.dcp.state.FailoverLogEntry;
import java.util.ArrayList;
import java.util.List;

public enum DcpFailoverLogResponse {


    public static boolean is(ByteBuf buffer) {
        return buffer.getByte(0) == -127 && buffer.getByte(1) == 84;
    }

    public static void init(ByteBuf buffer) {
        MessageUtil.initResponse((byte)84, buffer);
    }

    public static void vbucket(ByteBuf buffer, short vbid) {
        MessageUtil.setVbucket(vbid, buffer);
    }

    public static short vbucket(ByteBuf buffer) {
        int vbOffset = MessageUtil.getContent(buffer).readableBytes() - 2;
        return MessageUtil.getContent(buffer).getShort(vbOffset);
    }

    @Deprecated
    public static int numLogEntries(ByteBuf buffer) {
        return (MessageUtil.getContent(buffer).readableBytes() - 2) / 16;
    }

    @Deprecated
    public static long vbuuidEntry(ByteBuf buffer, int index) {
        return MessageUtil.getContent(buffer).getLong(index * 16);
    }

    @Deprecated
    public static long seqnoEntry(ByteBuf buffer, int index) {
        return MessageUtil.getContent(buffer).getLong(index * 16 + 8);
    }

    public static List<FailoverLogEntry> entries(ByteBuf buffer) {
        int numEntries = DcpFailoverLogResponse.numLogEntries(buffer);
        ByteBuf content = MessageUtil.getContent(buffer);
        ArrayList<FailoverLogEntry> result = new ArrayList<FailoverLogEntry>(numEntries);
        for (int i = 0; i < numEntries; ++i) {
            long vbuuid = content.getLong(i * 16);
            long seqno = content.getLong(i * 16 + 8);
            result.add(new FailoverLogEntry(seqno, vbuuid));
        }
        return result;
    }

    public static String toString(ByteBuf buffer) {
        return "FailoverLog [vbid: " + DcpFailoverLogResponse.vbucket(buffer) + ", log: " + DcpFailoverLogResponse.entries(buffer) + "]";
    }
}

