/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.message;

import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.dcp.message.MessageUtil;

public enum DcpOpenConnectionRequest {


    public static boolean is(ByteBuf buffer) {
        return buffer.getByte(0) == -128 && buffer.getByte(1) == 80;
    }

    public static void init(ByteBuf buffer) {
        MessageUtil.initRequest((byte)80, buffer);
        ByteBuf extras = Unpooled.buffer(8);
        MessageUtil.setExtras(extras.writeInt(0).writeInt(Type.PRODUCER.value), buffer);
        extras.release();
    }

    public static void connectionName(ByteBuf buffer, String connectionName) {
        MessageUtil.setKey(connectionName, buffer);
    }

    public static ByteBuf connectionName(ByteBuf buffer) {
        return MessageUtil.getKey(buffer);
    }

    static enum Type {
        CONSUMER(0),
        PRODUCER(1),
        NOTIFIER(2);

        private final int value;

        private Type(int value) {
            this.value = value;
        }
    }
}

