/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.message;

import com.couchbase.client.dcp.deps.io.netty.channel.Channel;
import com.couchbase.client.dcp.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.dcp.transport.netty.DcpConnectHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public enum HelloFeature {
    DATATYPE(1),
    TLS(2),
    TCP_NODELAY(3),
    MUTATION_SEQNO(4),
    TCP_DELAY(5),
    XATTR(6),
    XERROR(7),
    SELECT_BUCKET(8),
    SNAPPY(10),
    JSON(11),
    DUPLEX(12),
    CLUSTERMAP_CHANGE_NOTIFICATION(13),
    UNORDERED_EXECUTION(14),
    TRACING(15),
    ALT_REQUEST(16),
    SYNC_REPLICATION(17),
    COLLECTIONS(18),
    OPEN_TRACING(19),
    PRESERVE_TTL(20),
    VATTR(21);

    private final short code;
    private static final Map<Short, HelloFeature> codeToFeature;

    private HelloFeature(int code) {
        if (code < 0 || code > 65535) {
            throw new IllegalArgumentException("code doesn't fit in 2 bytes");
        }
        this.code = (short)code;
    }

    public boolean isEnabled(Channel channel) {
        return DcpConnectHandler.getFeatures(channel).contains((Object)this);
    }

    public boolean isEnabled(ChannelHandlerContext ctx) {
        return this.isEnabled(ctx.channel());
    }

    public short code() {
        return this.code;
    }

    public static HelloFeature forCode(short code) {
        HelloFeature f = codeToFeature.get(code);
        if (f == null) {
            throw new IllegalArgumentException("Unrecognized feature code: " + code);
        }
        return f;
    }

    public String toString() {
        return String.format("0x%04x (%s)", this.code(), this.name());
    }

    static {
        codeToFeature = Collections.unmodifiableMap(Arrays.stream(HelloFeature.values()).collect(Collectors.toMap(HelloFeature::code, f -> f)));
    }
}

