/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.message;

import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBufUtil;
import com.couchbase.client.dcp.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.dcp.deps.org.iq80.snappy.Snappy;
import com.couchbase.client.dcp.highlevel.internal.CollectionIdAndKey;
import com.couchbase.client.dcp.highlevel.internal.KeyExtractor;
import com.couchbase.client.dcp.message.ResponseStatus;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;

public enum MessageUtil {

    public static final int HEADER_SIZE = 24;
    public static final byte MAGIC_INT = 121;
    public static final byte MAGIC_REQ = -128;
    public static final byte MAGIC_RES = -127;
    public static final byte MAGIC_SERVER_REQ = -126;
    public static final byte MAGIC_SERVER_RES = -125;
    public static final short KEY_LENGTH_OFFSET = 2;
    public static final short EXTRAS_LENGTH_OFFSET = 4;
    public static final short DATA_TYPE_OFFSET = 5;
    public static final short VBUCKET_OFFSET = 6;
    public static final short BODY_LENGTH_OFFSET = 8;
    public static final short OPAQUE_OFFSET = 12;
    public static final short CAS_OFFSET = 16;
    public static final byte NOOP_OPCODE = 10;
    public static final byte VERSION_OPCODE = 11;
    public static final byte HELLO_OPCODE = 31;
    public static final byte SASL_LIST_MECHS_OPCODE = 32;
    public static final byte SASL_AUTH_OPCODE = 33;
    public static final byte SASL_STEP_OPCODE = 34;
    public static final byte GET_SEQNOS_OPCODE = 72;
    public static final byte OPEN_CONNECTION_OPCODE = 80;
    public static final byte DCP_ADD_STREAM_OPCODE = 81;
    public static final byte DCP_STREAM_CLOSE_OPCODE = 82;
    public static final byte DCP_STREAM_REQUEST_OPCODE = 83;
    public static final byte DCP_FAILOVER_LOG_OPCODE = 84;
    public static final byte DCP_STREAM_END_OPCODE = 85;
    public static final byte DCP_SNAPSHOT_MARKER_OPCODE = 86;
    public static final byte DCP_MUTATION_OPCODE = 87;
    public static final byte DCP_DELETION_OPCODE = 88;
    public static final byte DCP_EXPIRATION_OPCODE = 89;
    public static final byte DCP_FLUSH_OPCODE = 90;
    public static final byte DCP_SET_VBUCKET_STATE_OPCODE = 91;
    public static final byte DCP_NOOP_OPCODE = 92;
    public static final byte DCP_BUFFER_ACK_OPCODE = 93;
    public static final byte DCP_CONTROL_OPCODE = 94;
    public static final byte DCP_SYSTEM_EVENT_OPCODE = 95;
    public static final byte DCP_SEQNO_ADVANCED_OPCODE = 100;
    public static final byte DCP_OSO_SNAPSHOT_MARKER_OPCODE = 101;
    public static final byte SELECT_BUCKET_OPCODE = -119;
    public static final byte OBSERVE_SEQNO_OPCODE = -111;
    public static final byte GET_CLUSTER_CONFIG_OPCODE = -75;
    public static final byte GET_COLLECTIONS_MANIFEST_OPCODE = -70;
    public static final byte INTERNAL_ROLLBACK_OPCODE = 0;
    public static final byte CLUSTERMAP_CHANGE_NOTIFICATION_OPCODE = 1;
    public static final byte AUTHENTICATE_OPCODE = 2;
    public static final byte ACTIVE_EXTERNAL_USERS_OPCODE = 3;
    private static final String[] OPCODE_NAMES = MessageUtil.initOpcodeNames();
    private static final String[] FORMATTED_OPCODE_NAMES = MessageUtil.initFormattedOpcodeNames();

    private static String[] initOpcodeNames() {
        String[] names = new String[256];
        try {
            String suffix = "_OPCODE";
            for (Field f : MessageUtil.class.getDeclaredFields()) {
                String nameWithoutSuffix;
                if (f.getType() != Byte.TYPE || !Modifier.isPublic(f.getModifiers()) || !Modifier.isStatic(f.getModifiers()) || !f.getName().endsWith("_OPCODE")) continue;
                names[0xFF & f.getByte(null)] = nameWithoutSuffix = f.getName().substring(0, f.getName().length() - "_OPCODE".length());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return names;
    }

    private static String[] initFormattedOpcodeNames() {
        String[] names = new String[256];
        for (int i = 0; i < names.length; ++i) {
            String name = OPCODE_NAMES[i];
            names[i] = name == null ? String.format("0x%02x", i) : name;
        }
        return names;
    }

    public static int getOpcode(ByteBuf buf) {
        return buf.getByte(1) & 0xFF;
    }

    public static String getShortOpcodeName(int opcode) {
        try {
            return FORMATTED_OPCODE_NAMES[opcode];
        }
        catch (IndexOutOfBoundsException badRequestOrOpcodeArrayNotSizedCorrectly) {
            return String.valueOf(opcode);
        }
    }

    public static String getShortOpcodeName(ByteBuf buf) {
        return MessageUtil.getShortOpcodeName(MessageUtil.getOpcode(buf));
    }

    public static boolean isComplete(ByteBuf buffer) {
        int readable = buffer.readableBytes();
        if (readable < 24) {
            return false;
        }
        return readable >= 24 + buffer.getInt(8);
    }

    public static String humanize(ByteBuf buffer) {
        StringBuilder sb = new StringBuilder();
        byte extrasLength = buffer.getByte(4);
        short keyLength = buffer.getShort(2);
        int bodyLength = buffer.getInt(8);
        sb.append("Field          (offset) (value)\n-----------------------------------\n");
        sb.append(String.format("Magic          (0)      %s\n", MessageUtil.formatMagic(buffer.getByte(0))));
        sb.append(String.format("Opcode         (1)      %s\n", MessageUtil.formatOpcode(buffer.getByte(1))));
        sb.append(String.format("Key Length     (2,3)    0x%04x\n", keyLength));
        sb.append(String.format("Extras Length  (4)      0x%02x\n", extrasLength));
        sb.append(String.format("Data Type      (5)      0x%02x\n", buffer.getByte(5)));
        if (buffer.getByte(0) == -128) {
            sb.append(String.format("VBucket        (6,7)    0x%04x\n", buffer.getShort(6)));
        } else {
            sb.append(String.format("Status         (6,7)    %s\n", MessageUtil.getResponseStatus(buffer)));
        }
        sb.append(String.format("Total Body     (8-11)   0x%08x\n", bodyLength));
        sb.append(String.format("Opaque         (12-15)  0x%08x\n", buffer.getInt(12)));
        sb.append(String.format("CAS            (16-23)  0x%016x\n", buffer.getLong(16)));
        if (extrasLength > 0) {
            sb.append("+ Extras: \n" + ByteBufUtil.prettyHexDump(MessageUtil.getExtras(buffer)) + "\n");
        } else {
            sb.append("No Extras\n");
        }
        if (keyLength > 0) {
            sb.append("+ Key: \n" + ByteBufUtil.prettyHexDump(MessageUtil.getKey(buffer)) + "\n");
        } else {
            sb.append("No Key\n");
        }
        int contentLength = bodyLength - extrasLength - keyLength;
        if (contentLength > 0) {
            sb.append("+ Value: \n" + ByteBufUtil.prettyHexDump(MessageUtil.getContent(buffer)) + "\n");
        } else {
            sb.append("No Value\n");
        }
        return sb.toString();
    }

    public static void initRequest(byte opcode, ByteBuf buffer) {
        buffer.writeByte(-128);
        buffer.writeByte(opcode);
        buffer.writeZero(22);
    }

    public static void initResponse(byte opcode, ByteBuf buffer) {
        buffer.writeByte(-127);
        buffer.writeByte(opcode);
        buffer.writeZero(22);
    }

    public static void setExtras(ByteBuf extras, ByteBuf buffer) {
        byte oldExtrasLength = buffer.getByte(4);
        byte newExtrasLength = (byte)extras.readableBytes();
        int oldBodyLength = buffer.getInt(8);
        int newBodyLength = oldBodyLength - oldExtrasLength + newExtrasLength;
        buffer.setByte(4, newExtrasLength);
        buffer.setInt(8, newBodyLength);
        buffer.setBytes(24, extras);
        buffer.writerIndex(24 + newBodyLength);
    }

    public static ByteBuf getExtras(ByteBuf buffer) {
        return buffer.slice(24, buffer.getByte(4));
    }

    public static void setVbucket(short vbucket, ByteBuf buffer) {
        buffer.setShort(6, vbucket);
    }

    public static short getVbucket(ByteBuf buffer) {
        return buffer.getShort(6);
    }

    public static void setKey(String key, ByteBuf buffer) {
        byte[] keyBytes = key.getBytes(StandardCharsets.UTF_8);
        short oldKeyLength = buffer.getShort(2);
        short newKeyLength = (short)keyBytes.length;
        int oldBodyLength = buffer.getInt(8);
        byte extrasLength = buffer.getByte(4);
        int newBodyLength = oldBodyLength - oldKeyLength + newKeyLength;
        buffer.setShort(2, newKeyLength);
        buffer.setInt(8, newBodyLength);
        buffer.writerIndex(24 + extrasLength);
        buffer.writeBytes(keyBytes);
        buffer.writerIndex(24 + newBodyLength);
    }

    public static ByteBuf getKey(ByteBuf buffer) {
        byte extrasLength = buffer.getByte(4);
        short keyLength = buffer.getShort(2);
        return buffer.slice(24 + extrasLength, keyLength);
    }

    public static String getKeyAsString(ByteBuf buffer) {
        byte extrasLength = buffer.getByte(4);
        short keyLength = buffer.getShort(2);
        return buffer.toString(24 + extrasLength, keyLength, StandardCharsets.UTF_8);
    }

    public static CollectionIdAndKey getCollectionIdAndKey(ByteBuf buffer, boolean collectionsEnabled) {
        return (collectionsEnabled ? KeyExtractor.COLLECTIONS : KeyExtractor.NO_COLLECTIONS).getCollectionIdAndKey(buffer);
    }

    public static void setContent(ByteBuf content, ByteBuf buffer) {
        short keyLength = buffer.getShort(2);
        byte extrasLength = buffer.getByte(4);
        int bodyLength = keyLength + extrasLength + content.readableBytes();
        int contentOffset = 24 + extrasLength + keyLength;
        buffer.setInt(8, bodyLength);
        buffer.writerIndex(contentOffset);
        buffer.ensureWritable(content.readableBytes());
        buffer.writeBytes(content);
        buffer.writerIndex(24 + bodyLength);
    }

    public static void setContent(byte[] content, ByteBuf buffer) {
        MessageUtil.setContent(Unpooled.wrappedBuffer(content), buffer);
    }

    public static ByteBuf getRawContent(ByteBuf buffer) {
        short keyLength = buffer.getShort(2);
        byte extrasLength = buffer.getByte(4);
        int contentLength = buffer.getInt(8) - keyLength - extrasLength;
        return buffer.slice(24 + keyLength + extrasLength, contentLength);
    }

    public static ByteBuf getContent(ByteBuf buffer) {
        ByteBuf rawContent = MessageUtil.getRawContent(buffer);
        return MessageUtil.isSnappyCompressed(buffer) ? Unpooled.wrappedBuffer(MessageUtil.getContentAsByteArray(buffer)) : rawContent;
    }

    public static boolean isSnappyCompressed(ByteBuf buffer) {
        int DATA_TYPE_SNAPPY = 2;
        byte dataType = buffer.getByte(5);
        return (dataType & 2) == 2;
    }

    public static String getContentAsString(ByteBuf buffer) {
        return MessageUtil.getContent(buffer).toString(StandardCharsets.UTF_8);
    }

    public static byte[] getContentAsByteArray(ByteBuf buffer) {
        ByteBuf rawContent = MessageUtil.getRawContent(buffer);
        if (!MessageUtil.isSnappyCompressed(buffer)) {
            return ByteBufUtil.getBytes(rawContent);
        }
        if (rawContent.hasArray()) {
            return Snappy.uncompress(rawContent.array(), rawContent.arrayOffset() + rawContent.readerIndex(), rawContent.readableBytes());
        }
        byte[] compressed = ByteBufUtil.getBytes(rawContent);
        return Snappy.uncompress(compressed, 0, compressed.length);
    }

    @Deprecated
    public static short getStatus(ByteBuf buffer) {
        return buffer.getShort(6);
    }

    public static ResponseStatus getResponseStatus(ByteBuf buffer) {
        try {
            return ResponseStatus.valueOf(buffer.getShort(6));
        }
        catch (IndexOutOfBoundsException malformedResponse) {
            return ResponseStatus.MALFORMED_RESPONSE;
        }
    }

    public static boolean requiresFlowControlAck(ByteBuf message) {
        if (message.getByte(0) != -128) {
            return false;
        }
        switch (message.getByte(1)) {
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: {
                return true;
            }
        }
        return false;
    }

    public static byte getDataType(ByteBuf buffer) {
        return buffer.getByte(5);
    }

    public static void setDataType(byte dataType, ByteBuf buffer) {
        buffer.setByte(5, dataType);
    }

    public static void setOpaque(int opaque, ByteBuf buffer) {
        buffer.setInt(12, opaque);
    }

    public static int getOpaque(ByteBuf buffer) {
        return buffer.getInt(12);
    }

    public static long getCas(ByteBuf buffer) {
        return buffer.getLong(16);
    }

    private static String formatOpcode(byte opcode) {
        return String.format("0x%02x (%s)", opcode, MessageUtil.getOpcodeName(opcode));
    }

    private static String getOpcodeName(byte opcode) {
        String unknownName = "?";
        try {
            String name = OPCODE_NAMES[0xFF & opcode];
            return name == null ? "?" : name;
        }
        catch (IndexOutOfBoundsException opcodeArrayNotSizedCorrectly) {
            return "?";
        }
    }

    private static String formatMagic(byte magic) {
        String name;
        switch (magic) {
            case -128: {
                name = "REQUEST";
                break;
            }
            case -127: {
                name = "RESPONSE";
                break;
            }
            case -126: {
                name = "SERVER REQUEST";
                break;
            }
            case -125: {
                name = "SERVER RESPONSE";
                break;
            }
            default: {
                name = "?";
            }
        }
        return String.format("0x%02x (%s)", magic, name);
    }
}

