/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.message;

import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBuf;

public enum RollbackMessage {


    public static boolean is(ByteBuf buffer) {
        return buffer.getByte(0) == 121 && buffer.getByte(1) == 0;
    }

    public static void init(ByteBuf buffer, short vbid, long seqno) {
        buffer.writeByte(121);
        buffer.writeByte(0);
        buffer.writeShort(vbid);
        buffer.writeLong(seqno);
    }

    public static short vbucket(ByteBuf buffer) {
        return buffer.getShort(2);
    }

    public static long seqno(ByteBuf buffer) {
        return buffer.getLong(4);
    }

    public static String toString(ByteBuf buffer) {
        return "Rollback [vbid: " + RollbackMessage.vbucket(buffer) + ", seqno: " + RollbackMessage.seqno(buffer) + "]";
    }
}

