/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.metrics;

import com.couchbase.client.dcp.deps.io.netty.util.concurrent.Future;
import com.couchbase.client.dcp.metrics.LogLevel;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionCounter {
    private final String name;
    private final Counter successCounter;
    private final MeterRegistry registry;
    private final List<Tag> baseTags;
    private final LogLevel successLogLevel;
    private final LogLevel failureLogLevel;
    private final Logger logger;

    public static Builder builder(String name) {
        return new Builder(name);
    }

    private ActionCounter(MeterRegistry registry, String name, Iterable<Tag> tags, LogLevel successLogLevel, LogLevel failureLogLevel) {
        this.registry = Objects.requireNonNull(registry);
        this.name = Objects.requireNonNull(name);
        this.successLogLevel = Objects.requireNonNull(successLogLevel);
        this.failureLogLevel = Objects.requireNonNull(failureLogLevel);
        this.logger = LoggerFactory.getLogger((String)(ActionCounter.class.getName() + "." + name));
        ArrayList tagList = new ArrayList();
        tags.forEach(tagList::add);
        this.baseTags = Collections.unmodifiableList(tagList);
        ArrayList<Tag> successTags = new ArrayList<Tag>(this.baseTags);
        successTags.add(Tag.of((String)"result", (String)"success"));
        successTags.add(Tag.of((String)"exception", (String)"none"));
        this.successCounter = registry.counter(name, successTags);
    }

    public <V, F extends Future<V>> F track(F future) {
        future.addListener(f -> {
            if (f.isSuccess()) {
                this.success();
            } else {
                this.failure(f.cause());
            }
        });
        return future;
    }

    public <V, F extends Future<V>> F track(F future, Function<V, String> errorExtractor) {
        future.addListener(f -> {
            if (!f.isSuccess()) {
                this.failure(f.cause());
            } else {
                String error = (String)errorExtractor.apply(f.getNow());
                if (error != null) {
                    this.failure(error);
                } else {
                    this.success();
                }
            }
        });
        return future;
    }

    public void success() {
        this.successLogLevel.log(this.logger, "success {}", (Object)this.baseTags);
        this.successCounter.increment();
    }

    public void failure(Throwable reason) {
        this.failureLogLevel.log(this.logger, "failure {}", (Object)this.baseTags, (Object)reason);
        String reasonName = reason == null ? "unknown" : reason.getClass().getSimpleName();
        this.failure(reasonName);
    }

    public void failure(String exception) {
        Counter.builder((String)this.name).tags(this.baseTags).tag("result", "failure").tag("exception", exception).register(this.registry).increment();
    }

    public void run(Runnable task) {
        try {
            task.run();
            this.success();
        }
        catch (Throwable t) {
            this.failure(t);
            throw t;
        }
    }

    public <T> T call(Callable<T> task) throws Exception {
        try {
            T result = task.call();
            this.success();
            return result;
        }
        catch (Throwable t) {
            this.failure(t);
            throw t;
        }
    }

    public Runnable wrap(Runnable r) {
        return () -> this.run(r);
    }

    public <T> Callable<T> wrap(Callable<T> c) {
        return () -> this.call(c);
    }

    public static class Builder {
        private final String name;
        private MeterRegistry registry = Metrics.globalRegistry;
        private List<Tag> baseTags = new ArrayList<Tag>();
        private LogLevel successLogLevel = LogLevel.INFO;
        private LogLevel failureLogLevel = LogLevel.WARN;

        private Builder(String name) {
            this.name = Objects.requireNonNull(name);
        }

        public Builder registry(MeterRegistry registry) {
            this.registry = Objects.requireNonNull(registry);
            return this;
        }

        public Builder tag(String key, String value) {
            return this.tag(Tag.of((String)key, (String)value));
        }

        public Builder tag(Tag tag) {
            this.baseTags.add(Objects.requireNonNull(tag));
            return this;
        }

        public Builder tags(Iterable<Tag> tag) {
            tag.forEach(this::tag);
            return this;
        }

        public Builder logLevel(LogLevel logLevel) {
            return this.successLogLevel(logLevel).failureLogLevel(logLevel);
        }

        public Builder successLogLevel(LogLevel logLevel) {
            this.successLogLevel = Objects.requireNonNull(logLevel);
            return this;
        }

        public Builder failureLogLevel(LogLevel logLevel) {
            this.failureLogLevel = Objects.requireNonNull(logLevel);
            return this;
        }

        public ActionCounter build() {
            return new ActionCounter(this.registry, this.name, this.baseTags, this.successLogLevel, this.failureLogLevel);
        }
    }
}

