/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.metrics;

import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.deps.io.netty.util.concurrent.Future;
import com.couchbase.client.dcp.deps.io.netty.util.concurrent.Promise;
import com.couchbase.client.dcp.message.DcpStreamEndMessage;
import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.dcp.message.ResponseStatus;
import com.couchbase.client.dcp.metrics.ActionCounter;
import com.couchbase.client.dcp.metrics.EventCounter;
import com.couchbase.client.dcp.metrics.LogLevel;
import com.couchbase.client.dcp.metrics.MetricsContext;
import com.couchbase.client.dcp.transport.netty.DcpResponse;

public class DcpChannelMetrics {
    private final MetricsContext ctx;
    private final ActionCounter connect;
    private final ActionCounter disconnect;
    private final EventCounter mutation;
    private final EventCounter deletion;
    private final EventCounter expiration;
    private final EventCounter snapshot;
    private final EventCounter bytesRead;
    private volatile int prevDcpRequestOpcode;
    private volatile ActionCounter prevDcpRequestCounter;

    public DcpChannelMetrics(MetricsContext ctx) {
        this.ctx = ctx;
        this.connect = ctx.newActionCounter("connect").build();
        this.disconnect = ctx.newActionCounter("disconnect").build();
        this.mutation = this.serverRequestCounter(87).build();
        this.deletion = this.serverRequestCounter(88).build();
        this.expiration = this.serverRequestCounter(89).build();
        this.snapshot = this.serverRequestCounter(86).build();
        this.bytesRead = ctx.newEventCounter("bytes.read").logLevel(LogLevel.NONE).build();
    }

    public <V, F extends Future<V>> F trackConnect(F future) {
        return this.connect.track(future);
    }

    public <V, F extends Future<V>> F trackDisconnect(F future) {
        return this.disconnect.track(future);
    }

    public void trackDcpRequest(Promise<DcpResponse> promise, ByteBuf request) {
        int opcode = MessageUtil.getOpcode(request);
        if (opcode != this.prevDcpRequestOpcode || this.prevDcpRequestCounter == null) {
            this.prevDcpRequestOpcode = opcode;
            this.prevDcpRequestCounter = this.ctx.newActionCounter("client.request").tag("opcode", MessageUtil.getShortOpcodeName(opcode)).logLevel(LogLevel.DEBUG).build();
        }
        this.prevDcpRequestCounter.track(promise, dcpResponse -> {
            ResponseStatus status = dcpResponse.status();
            return status.isSuccess() ? null : status.symbolicName();
        });
    }

    public void incrementBytesRead(long bytes) {
        this.bytesRead.increment(bytes);
    }

    public void incrementDeadConnections() {
        this.ctx.newEventCounter("dead.connection").build().increment();
    }

    public void recordServerRequest(ByteBuf message) {
        int opcode = MessageUtil.getOpcode(message);
        switch (opcode) {
            case 87: {
                this.mutation.increment();
                return;
            }
            case 86: {
                this.snapshot.increment();
                return;
            }
            case 88: {
                this.deletion.increment();
                return;
            }
            case 89: {
                this.expiration.increment();
                return;
            }
            case 85: {
                this.recordStreamEnd(message);
                return;
            }
        }
        this.serverRequestCounter(opcode).build().increment();
    }

    private void recordStreamEnd(ByteBuf message) {
        this.ctx.newEventCounter("stream.end").tag("reason", DcpStreamEndMessage.getReasonAsString(message)).logLevel(LogLevel.DEBUG).build().increment();
    }

    private EventCounter.Builder serverRequestCounter(int opcode) {
        return this.ctx.newEventCounter("server.request").tag("opcode", MessageUtil.getShortOpcodeName(opcode)).logLevel(LogLevel.NONE);
    }
}

