/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.state;

import com.couchbase.client.dcp.deps.com.fasterxml.jackson.databind.ObjectMapper;
import com.couchbase.client.dcp.deps.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.couchbase.client.dcp.deps.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.couchbase.client.dcp.highlevel.SnapshotMarker;
import com.couchbase.client.dcp.state.FailoverLogEntry;
import com.couchbase.client.dcp.state.PartitionState;
import com.couchbase.client.dcp.state.StateFormat;
import com.couchbase.client.dcp.state.json.SessionStateDeserializer;
import com.couchbase.client.dcp.state.json.SessionStateSerializer;
import com.couchbase.client.dcp.util.MathUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BiConsumer;
import rx.functions.Action1;

@JsonSerialize(using=SessionStateSerializer.class)
@JsonDeserialize(using=SessionStateDeserializer.class)
public class SessionState {
    private static final ObjectMapper JACKSON = new ObjectMapper();
    public static final long NO_END_SEQNO = -1L;
    public static final int CURRENT_VERSION = 1;
    private static final int MAX_PARTITIONS = 1024;
    private final AtomicReferenceArray<PartitionState> partitionStates = new AtomicReferenceArray(1024);

    public void setToBeginningWithNoEnd(int numPartitions) {
        if (numPartitions > 1024) {
            throw new IllegalArgumentException("Can only hold 1024 partitions, " + numPartitions + "supplied as initializer.");
        }
        for (int i = 0; i < numPartitions; ++i) {
            PartitionState partitionState = new PartitionState();
            partitionState.setEndSeqno(-1L);
            partitionState.setStartSeqno(0L);
            partitionState.setSnapshot(SnapshotMarker.NONE);
            this.partitionStates.set(i, partitionState);
        }
    }

    public void setFromJson(byte[] persisted) {
        try {
            SessionState decoded = JACKSON.readValue(persisted, SessionState.class);
            decoded.foreachPartition(new Action1<PartitionState>(){
                int i = 0;

                public void call(PartitionState dps) {
                    SessionState.this.partitionStates.set(this.i++, dps);
                }
            });
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not decode SessionState from JSON.", ex);
        }
    }

    public PartitionState get(int partition) {
        return this.partitionStates.get(partition);
    }

    public void set(int partition, PartitionState partitionState) {
        this.partitionStates.set(partition, partitionState);
    }

    public boolean isAtEnd() {
        AtomicBoolean atEnd = new AtomicBoolean(true);
        this.foreachPartition((Action1<PartitionState>)((Action1)ps -> {
            if (!ps.isAtEnd()) {
                atEnd.set(false);
            }
        }));
        return atEnd.get();
    }

    public void rollbackToPosition(short partition, long seqno) {
        PartitionState ps = this.partitionStates.get(partition);
        ps.setStartSeqno(seqno);
        ps.setSnapshot(new SnapshotMarker(seqno, seqno));
        List<FailoverLogEntry> failoverLog = ps.getFailoverLog();
        Iterator<FailoverLogEntry> flogIterator = failoverLog.iterator();
        ArrayList<FailoverLogEntry> entriesToRemove = new ArrayList<FailoverLogEntry>();
        while (flogIterator.hasNext()) {
            FailoverLogEntry entry = flogIterator.next();
            if (!MathUtils.lessThanUnsigned(seqno, entry.getSeqno())) continue;
            entriesToRemove.add(entry);
        }
        failoverLog.removeAll(entriesToRemove);
        this.partitionStates.set(partition, ps);
    }

    public void foreachPartition(Action1<PartitionState> action) {
        int len = this.partitionStates.length();
        for (int i = 0; i < len; ++i) {
            PartitionState ps = this.partitionStates.get(i);
            if (ps == null) continue;
            action.call((Object)ps);
        }
    }

    public void foreachPartition(BiConsumer<Integer, PartitionState> consumer) {
        int len = this.partitionStates.length();
        for (int i = 0; i < len; ++i) {
            PartitionState ps = this.partitionStates.get(i);
            if (ps == null) continue;
            consumer.accept(i, ps);
        }
    }

    public byte[] export(StateFormat format) {
        try {
            if (format == StateFormat.JSON) {
                return JACKSON.writeValueAsBytes(this);
            }
            throw new IllegalStateException("Unsupported Format " + (Object)((Object)format));
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not encode SessionState to Format " + (Object)((Object)format), ex);
        }
    }

    public String toString() {
        return "SessionState[" + this.partitionStates + ']';
    }
}

