/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.transport.netty;

import com.couchbase.client.dcp.core.endpoint.kv.AuthenticationException;
import com.couchbase.client.dcp.core.security.sasl.Sasl;
import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.dcp.deps.io.netty.channel.ChannelFuture;
import com.couchbase.client.dcp.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.dcp.deps.io.netty.util.concurrent.Future;
import com.couchbase.client.dcp.deps.io.netty.util.concurrent.GenericFutureListener;
import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.dcp.message.ResponseStatus;
import com.couchbase.client.dcp.message.SaslAuthRequest;
import com.couchbase.client.dcp.message.SaslAuthResponse;
import com.couchbase.client.dcp.message.SaslListMechsRequest;
import com.couchbase.client.dcp.message.SaslListMechsResponse;
import com.couchbase.client.dcp.message.SaslStepRequest;
import com.couchbase.client.dcp.message.SaslStepResponse;
import com.couchbase.client.dcp.transport.netty.ConnectInterceptingHandler;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuthHandler
extends ConnectInterceptingHandler<ByteBuf>
implements CallbackHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthHandler.class);
    private final String username;
    private final String password;
    private SaslClient saslClient;
    private String selectedMechanism;

    AuthHandler(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ByteBuf request = ctx.alloc().buffer();
        SaslListMechsRequest.init(request);
        ctx.writeAndFlush(request);
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        if (SaslListMechsResponse.is(msg)) {
            this.handleListMechsResponse(ctx, msg);
        } else if (SaslAuthResponse.is(msg)) {
            this.handleAuthResponse(ctx, msg);
        } else if (SaslStepResponse.is(msg)) {
            this.checkIsAuthed(ctx, MessageUtil.getResponseStatus(msg));
        } else {
            throw new IllegalStateException("Received unexpected SASL response! " + MessageUtil.humanize(msg));
        }
    }

    private void handleAuthResponse(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        ByteBuf content;
        if (this.saslClient.isComplete()) {
            this.checkIsAuthed(ctx, MessageUtil.getResponseStatus(msg));
            return;
        }
        ByteBuf challengeBuf = SaslAuthResponse.challenge(msg);
        byte[] challenge = new byte[challengeBuf.readableBytes()];
        challengeBuf.readBytes(challenge);
        byte[] evaluatedBytes = this.saslClient.evaluateChallenge(challenge);
        if (evaluatedBytes != null) {
            if (this.selectedMechanism.equals("CRAM-MD5") || this.selectedMechanism.equals("PLAIN")) {
                String[] evaluated = new String(evaluatedBytes).split(" ");
                content = Unpooled.copiedBuffer(this.username + "\u0000" + evaluated[1], StandardCharsets.UTF_8);
            } else {
                content = Unpooled.wrappedBuffer(evaluatedBytes);
            }
        } else {
            throw new AuthenticationException("SASL Challenge evaluation returned null.");
        }
        ByteBuf request = ctx.alloc().buffer();
        SaslStepRequest.init(request);
        SaslStepRequest.mechanism(this.selectedMechanism, request);
        SaslStepRequest.challengeResponse(content, request);
        ChannelFuture future = ctx.writeAndFlush(request);
        future.addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<Void>>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess()) {
                    LOGGER.warn("Error during SASL Auth negotiation phase.", future.cause());
                    AuthHandler.this.originalPromise().setFailure(future.cause());
                }
            }
        });
    }

    private void checkIsAuthed(ChannelHandlerContext ctx, ResponseStatus status) {
        if (status.isSuccess()) {
            LOGGER.debug("Successfully authenticated against node {}", (Object)ctx.channel().remoteAddress());
            ctx.pipeline().remove(this);
            this.originalPromise().setSuccess();
            ctx.fireChannelActive();
        } else if (status == ResponseStatus.AUTH_ERROR) {
            this.originalPromise().setFailure(new AuthenticationException("SASL Authentication Failure"));
        } else {
            this.originalPromise().setFailure(new AuthenticationException("Unhandled SASL auth status: " + status));
        }
    }

    private void handleListMechsResponse(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        String remote = ctx.channel().remoteAddress().toString();
        String[] supportedMechanisms = SaslListMechsResponse.supportedMechs(msg);
        if (supportedMechanisms.length == 0) {
            throw new AuthenticationException("Received empty SASL mechanisms list from server: " + remote);
        }
        this.saslClient = Sasl.createSaslClient(supportedMechanisms, null, "couchbase", remote, null, this);
        this.selectedMechanism = this.saslClient.getMechanismName();
        byte[] bytePayload = this.saslClient.hasInitialResponse() ? this.saslClient.evaluateChallenge(new byte[0]) : null;
        ByteBuf payload = bytePayload != null ? ctx.alloc().buffer().writeBytes(bytePayload) : Unpooled.EMPTY_BUFFER;
        ByteBuf request = ctx.alloc().buffer();
        SaslAuthRequest.init(request);
        SaslAuthRequest.mechanism(this.selectedMechanism, request);
        SaslAuthRequest.challengeResponse(payload, request);
        payload.release();
        ChannelFuture future = ctx.writeAndFlush(request);
        future.addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<Void>>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess()) {
                    LOGGER.warn("Error during SASL Auth negotiation phase.", future.cause());
                    AuthHandler.this.originalPromise().setFailure(future.cause());
                }
            }
        });
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.username);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                continue;
            }
            throw new AuthenticationException("SASLClient requested unsupported callback: " + callback);
        }
    }
}

