/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.transport.netty;

import com.couchbase.client.dcp.config.ClientEnvironment;
import com.couchbase.client.dcp.config.DcpControl;
import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.deps.io.netty.channel.Channel;
import com.couchbase.client.dcp.deps.io.netty.util.concurrent.Future;
import com.couchbase.client.dcp.deps.io.netty.util.concurrent.GenericFutureListener;
import com.couchbase.client.dcp.message.DcpBufferAckRequest;
import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.dcp.transport.netty.ChannelFlowController;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelFlowControllerImpl
implements ChannelFlowController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelFlowControllerImpl.class);
    private final Channel channel;
    private final boolean needsBufferAck;
    private final int bufferAckWatermark;
    private int bufferAckCounter;

    public ChannelFlowControllerImpl(Channel channel, ClientEnvironment environment) {
        this.channel = Objects.requireNonNull(channel);
        this.needsBufferAck = environment.dcpControl().bufferAckEnabled();
        if (this.needsBufferAck) {
            int bufferAckPercent = environment.bufferAckWatermark();
            int bufferSize = Integer.parseInt(environment.dcpControl().get(DcpControl.Names.CONNECTION_BUFFER_SIZE));
            this.bufferAckWatermark = (int)Math.round((double)bufferSize / 100.0 * (double)bufferAckPercent);
            LOGGER.debug("BufferAckWatermark absolute is {}", (Object)this.bufferAckWatermark);
        } else {
            this.bufferAckWatermark = 0;
        }
        this.bufferAckCounter = 0;
    }

    @Override
    public void ack(ByteBuf message) {
        if (this.needsBufferAck && MessageUtil.requiresFlowControlAck(message)) {
            this.ack(message.readableBytes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ack(int numBytes) {
        if (!this.needsBufferAck) {
            return;
        }
        try {
            ChannelFlowControllerImpl channelFlowControllerImpl = this;
            synchronized (channelFlowControllerImpl) {
                this.bufferAckCounter += numBytes;
                LOGGER.trace("BufferAckCounter is now {}", (Object)this.bufferAckCounter);
                if (this.bufferAckCounter >= this.bufferAckWatermark) {
                    if (!this.channel.isActive()) {
                        LOGGER.trace("Skipping flow control ACK because channel is no longer active.");
                    } else {
                        int bytesToAck = this.bufferAckCounter;
                        LOGGER.trace("BufferAckWatermark reached on {}, acking now against the server.", (Object)this.channel.remoteAddress());
                        ByteBuf buffer = this.channel.alloc().buffer();
                        DcpBufferAckRequest.init(buffer);
                        DcpBufferAckRequest.ackBytes(buffer, bytesToAck);
                        this.channel.writeAndFlush(buffer).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                            if (future.isSuccess()) {
                                LOGGER.debug("Flow control ACK success, confirmed {} bytes against channel {}", (Object)bytesToAck, (Object)this.channel);
                            } else {
                                LOGGER.error("Flow control ACK failed; closing channel.", future.cause());
                                this.channel.close();
                            }
                        }));
                    }
                    this.bufferAckCounter = 0;
                }
                LOGGER.trace("Acknowledging {} bytes against connection {}.", (Object)numBytes, (Object)this.channel.remoteAddress());
            }
        }
        catch (Throwable t) {
            if (!this.channel.isActive()) {
                LOGGER.debug("Flow control ack failed (channel already closed?)", t);
                return;
            }
            LOGGER.error("Flow control ACK failed; closing channel.", t);
            this.channel.close();
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw (RuntimeException)t;
        }
    }
}

