/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.transport.netty;

import com.couchbase.client.dcp.Credentials;
import com.couchbase.client.dcp.buffer.PersistencePollingHandler;
import com.couchbase.client.dcp.conductor.BucketConfigArbiter;
import com.couchbase.client.dcp.conductor.DcpChannelControlHandler;
import com.couchbase.client.dcp.config.ClientEnvironment;
import com.couchbase.client.dcp.config.DcpControl;
import com.couchbase.client.dcp.config.SSLEngineFactory;
import com.couchbase.client.dcp.deps.io.netty.channel.Channel;
import com.couchbase.client.dcp.deps.io.netty.channel.ChannelInitializer;
import com.couchbase.client.dcp.deps.io.netty.channel.ChannelPipeline;
import com.couchbase.client.dcp.deps.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import com.couchbase.client.dcp.deps.io.netty.handler.logging.LogLevel;
import com.couchbase.client.dcp.deps.io.netty.handler.logging.LoggingHandler;
import com.couchbase.client.dcp.deps.io.netty.handler.ssl.SslHandler;
import com.couchbase.client.dcp.deps.io.netty.handler.timeout.IdleStateHandler;
import com.couchbase.client.dcp.metrics.DcpChannelMetrics;
import com.couchbase.client.dcp.transport.netty.AuthHandler;
import com.couchbase.client.dcp.transport.netty.BucketConfigHandler;
import com.couchbase.client.dcp.transport.netty.ClientNoopHandler;
import com.couchbase.client.dcp.transport.netty.DcpConnectHandler;
import com.couchbase.client.dcp.transport.netty.DcpControlHandler;
import com.couchbase.client.dcp.transport.netty.DcpLoggingHandler;
import com.couchbase.client.dcp.transport.netty.DcpMessageHandler;
import com.couchbase.client.dcp.transport.netty.HandshakeTimeoutHandler;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcpPipeline
extends ChannelInitializer<Channel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DcpPipeline.class);
    private final ClientEnvironment environment;
    private final DcpChannelControlHandler controlHandler;
    private final SSLEngineFactory sslEngineFactory;
    private final BucketConfigArbiter bucketConfigArbiter;
    private final DcpChannelMetrics metrics;

    public DcpPipeline(ClientEnvironment environment, DcpChannelControlHandler controlHandler, BucketConfigArbiter bucketConfigArbiter, DcpChannelMetrics metrics) {
        this.bucketConfigArbiter = Objects.requireNonNull(bucketConfigArbiter);
        this.environment = Objects.requireNonNull(environment);
        this.controlHandler = Objects.requireNonNull(controlHandler);
        this.metrics = Objects.requireNonNull(metrics);
        this.sslEngineFactory = environment.sslEnabled() ? new SSLEngineFactory(environment) : null;
    }

    @Override
    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        int gracePeriodMillis = Integer.parseInt(System.getProperty("com.couchbase.connectCallbackGracePeriod", "2000"));
        if (gracePeriodMillis != 0) {
            long handshakeTimeoutMillis = this.environment.socketConnectTimeout() + (long)gracePeriodMillis;
            pipeline.addLast(new HandshakeTimeoutHandler(handshakeTimeoutMillis, TimeUnit.MILLISECONDS));
        }
        if (this.environment.sslEnabled()) {
            pipeline.addLast(new SslHandler(this.sslEngineFactory.get()));
        }
        pipeline.addLast(new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 8, 4, 12, 0, false));
        if (LOGGER.isTraceEnabled()) {
            pipeline.addLast(new LoggingHandler(LogLevel.TRACE));
        }
        DcpControl control = this.environment.dcpControl();
        Credentials credentials = this.environment.credentialsProvider().get((InetSocketAddress)ch.remoteAddress());
        pipeline.addLast(new AuthHandler(credentials.getUsername(), credentials.getPassword())).addLast(new BucketConfigHandler(this.bucketConfigArbiter, this.environment.configRefreshInterval())).addLast(new DcpConnectHandler(this.environment)).addLast(new DcpControlHandler(control));
        if (control.noopEnabled()) {
            pipeline.addLast(new IdleStateHandler(2 * control.noopIntervalSeconds(), 0, 0));
            long serverNoopIntervalMillis = TimeUnit.SECONDS.toMillis(control.noopIntervalSeconds());
            long clientNoopIntervalMillis = (long)((double)serverNoopIntervalMillis * 1.2);
            pipeline.addLast(new ClientNoopHandler(clientNoopIntervalMillis, TimeUnit.MILLISECONDS));
        }
        if (LOGGER.isTraceEnabled()) {
            pipeline.addLast(new DcpLoggingHandler(LogLevel.TRACE));
        }
        DcpMessageHandler messageHandler = new DcpMessageHandler(ch, this.environment, this.controlHandler, this.metrics);
        pipeline.addLast(messageHandler);
        if (this.environment.persistencePollingEnabled()) {
            pipeline.addLast(new PersistencePollingHandler(this.environment, this.bucketConfigArbiter, messageHandler));
        }
    }
}

