/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.buffer;

import com.couchbase.client.dcp.buffer.DcpOps;
import com.couchbase.client.dcp.buffer.DcpRequestDispatcher;
import com.couchbase.client.dcp.buffer.FailoverLogResponse;
import com.couchbase.client.dcp.buffer.ObserveSeqnoResponse;
import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.dcp.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.dcp.deps.io.netty.util.concurrent.Future;
import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.dcp.message.ResponseStatus;
import com.couchbase.client.dcp.transport.netty.DcpResponse;
import com.couchbase.client.dcp.transport.netty.DcpResponseListener;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class DcpOpsImpl
implements DcpOps {
    private final DcpRequestDispatcher dispatcher;

    public DcpOpsImpl(DcpRequestDispatcher dispatcher) {
        this.dispatcher = Objects.requireNonNull(dispatcher);
    }

    @Override
    public Mono<ObserveSeqnoResponse> observeSeqno(int partition, long vbuuid) {
        return this.doRequest(() -> DcpRequestBuilder.request((byte)-111).vbucket(partition).content(Unpooled.buffer(8).writeLong(vbuuid)), ObserveSeqnoResponse::new);
    }

    @Override
    public Mono<FailoverLogResponse> getFailoverLog(int partition) {
        return this.doRequest(() -> DcpRequestBuilder.request((byte)84).vbucket(partition), FailoverLogResponse::new);
    }

    private <R> Mono<R> doRequest(Supplier<DcpRequestBuilder> requestBuilder, Function<ByteBuf, R> resultExtractor) {
        return Mono.create(sink -> {
            try {
                ByteBuf request = ((DcpRequestBuilder)requestBuilder.get()).build();
                this.dispatcher.sendRequest(request).addListener(new DcpResponseListener((MonoSink)sink, resultExtractor){
                    final /* synthetic */ MonoSink val$sink;
                    final /* synthetic */ Function val$resultExtractor;
                    {
                        this.val$sink = monoSink;
                        this.val$resultExtractor = function;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void operationComplete(Future<DcpResponse> future) {
                        if (!future.isSuccess()) {
                            this.val$sink.error(future.cause());
                            return;
                        }
                        ByteBuf buf = future.getNow().buffer();
                        try {
                            ResponseStatus status = MessageUtil.getResponseStatus(buf);
                            if (!status.isSuccess()) {
                                throw new DcpOps.BadResponseStatusException(status);
                            }
                            Object result = this.val$resultExtractor.apply(buf);
                            this.val$sink.success(result);
                        }
                        catch (Throwable t) {
                            this.val$sink.error(t);
                        }
                        finally {
                            buf.release();
                        }
                    }
                });
            }
            catch (Throwable t) {
                sink.error(t);
            }
        });
    }

    static class DcpRequestBuilder {
        private final byte opcode;
        private int vbucket;
        private ByteBuf content;
        private boolean used;

        private DcpRequestBuilder(byte opcode) {
            this.opcode = opcode;
        }

        static DcpRequestBuilder request(byte opcode) {
            return new DcpRequestBuilder(opcode);
        }

        DcpRequestBuilder vbucket(int vbucket) {
            this.vbucket = vbucket;
            return this;
        }

        DcpRequestBuilder content(ByteBuf content) {
            this.content = content;
            return this;
        }

        ByteBuf build() {
            if (this.used) {
                throw new IllegalStateException("Not reusable");
            }
            try {
                ByteBuf buf = Unpooled.buffer();
                MessageUtil.initRequest(this.opcode, buf);
                MessageUtil.setVbucket(this.vbucket, buf);
                if (this.content != null) {
                    MessageUtil.setContent(this.content, buf);
                }
                ByteBuf byteBuf = buf;
                return byteBuf;
            }
            finally {
                this.used = true;
                ReferenceCountUtil.release(this.content);
            }
        }
    }
}

