/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.config;

import com.couchbase.client.dcp.config.CompressionMode;
import com.couchbase.client.dcp.util.Version;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcpControl {
    private static final Logger LOGGER = LoggerFactory.getLogger(DcpControl.class);
    private static final int DEFAULT_NOOP_INTERVAL_SECONDS = 120;
    private Map<String, String> values;
    private CompressionMode compressionMode = CompressionMode.ENABLED;

    public DcpControl() {
        this.values = new HashMap<String, String>();
    }

    public void compression(CompressionMode compressionMode) {
        this.compressionMode = Objects.requireNonNull(compressionMode);
    }

    public CompressionMode compression(Version version) {
        return this.compressionMode.effectiveMode(version);
    }

    public DcpControl put(Names name, String value) {
        if (name == Names.ENABLE_NOOP && this.get(Names.SET_NOOP_INTERVAL) == null) {
            this.put(Names.SET_NOOP_INTERVAL, Integer.toString(120));
        }
        this.values.put(name.value(), value);
        return this;
    }

    public String get(Names name) {
        return this.values.get(name.value());
    }

    public boolean bufferAckEnabled() {
        String bufSize = this.get(Names.CONNECTION_BUFFER_SIZE);
        return bufSize != null && Integer.parseInt(bufSize) > 0;
    }

    public boolean noopEnabled() {
        return "true".equals(this.get(Names.ENABLE_NOOP));
    }

    public int noopIntervalSeconds() {
        try {
            return DcpControl.parsePositiveInteger(this.get(Names.SET_NOOP_INTERVAL));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Bad value for '" + Names.SET_NOOP_INTERVAL.value() + "'; " + e.getMessage());
        }
    }

    private static int parsePositiveInteger(String s) {
        int value = Integer.parseInt(s);
        if (value < 1) {
            throw new IllegalArgumentException("Value '" + s + "' is not positive.");
        }
        return value;
    }

    public Map<String, String> getControls(Version serverVersion) {
        CompressionMode effectiveMode = this.compression(serverVersion);
        if (this.compressionMode != effectiveMode) {
            LOGGER.info("Couchbase Server version {} does not support {} compression mode; falling back to {}.", new Object[]{serverVersion, this.compressionMode, effectiveMode});
        } else {
            LOGGER.debug("Compression mode: {}", (Object)this.compressionMode);
        }
        HashMap<String, String> result = new HashMap<String, String>(this.values);
        result.putAll(effectiveMode.getDcpControls(serverVersion));
        return result;
    }

    public String toString() {
        return "DcpControl{" + this.values + '}';
    }

    public static enum Names {
        ENABLE_NOOP("enable_noop"),
        CONNECTION_BUFFER_SIZE("connection_buffer_size"),
        SET_NOOP_INTERVAL("set_noop_interval"),
        SET_PRIORITY("set_priority"),
        ENABLE_EXT_METADATA("enable_ext_metadata"),
        ENABLE_VALUE_COMPRESSION("enable_value_compression"),
        SUPPORTS_CURSOR_DROPPING("supports_cursor_dropping");

        private String value;

        private Names(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

