/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.config;

import java.net.InetSocketAddress;
import java.util.Objects;

public class HostAndPort {
    private final String host;
    private final int port;
    private final boolean ipv6Literal;

    public HostAndPort(String host, int port) {
        this.ipv6Literal = host.contains(":");
        this.host = this.ipv6Literal ? HostAndPort.canonicalizeIpv6Literal(host) : host;
        this.port = port;
    }

    private static String canonicalizeIpv6Literal(String ipv6Literal) {
        return new InetSocketAddress("[" + ipv6Literal + "]", 0).getHostString();
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public HostAndPort withPort(int port) {
        return this.port == port ? this : new HostAndPort(this.host, port);
    }

    public String format() {
        return this.formatHost() + ":" + this.port;
    }

    public String formatHost() {
        return this.ipv6Literal ? "[" + this.host + "]" : this.host;
    }

    public String toString() {
        return this.format();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostAndPort that = (HostAndPort)o;
        return this.port == that.port && this.host.equals(that.host);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }
}

