/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.config;

import com.couchbase.client.dcp.core.config.AlternateAddress;
import com.couchbase.client.dcp.core.config.BucketCapabilities;
import com.couchbase.client.dcp.core.config.BucketConfig;
import com.couchbase.client.dcp.core.config.BucketNodeLocator;
import com.couchbase.client.dcp.core.config.DefaultNodeInfo;
import com.couchbase.client.dcp.core.config.NodeInfo;
import com.couchbase.client.dcp.core.config.PortInfo;
import com.couchbase.client.dcp.core.service.ServiceType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBucketConfig
implements BucketConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBucketConfig.class);
    private final String uuid;
    private final String name;
    private String username;
    private String password;
    private final BucketNodeLocator locator;
    private final String uri;
    private final String streamingUri;
    private final List<NodeInfo> nodeInfo;
    private final int enabledServices;
    private final List<BucketCapabilities> bucketCapabilities;
    private final String origin;
    private volatile String useAlternateNetwork;

    protected AbstractBucketConfig(String uuid, String name, BucketNodeLocator locator, String uri, String streamingUri, List<NodeInfo> nodeInfos, List<PortInfo> portInfos, List<BucketCapabilities> bucketCapabilities, String origin) {
        this.uuid = uuid;
        this.name = name;
        this.locator = locator;
        this.uri = uri;
        this.streamingUri = streamingUri;
        this.bucketCapabilities = bucketCapabilities;
        this.origin = origin;
        this.nodeInfo = portInfos == null ? nodeInfos : this.nodeInfoFromExtended(portInfos, nodeInfos);
        int es = 0;
        for (NodeInfo info : this.nodeInfo) {
            for (ServiceType type : info.services().keySet()) {
                es |= 1 << type.ordinal();
            }
            for (ServiceType type : info.sslServices().keySet()) {
                es |= 1 << type.ordinal();
            }
        }
        this.enabledServices = es;
    }

    private List<NodeInfo> nodeInfoFromExtended(List<PortInfo> nodesExt, List<NodeInfo> nodeInfos) {
        ArrayList<NodeInfo> converted = new ArrayList<NodeInfo>(nodesExt.size());
        for (int i = 0; i < nodesExt.size(); ++i) {
            NodeInfo nodeInfo;
            String hostname = nodesExt.get(i).hostname();
            NodeInfo nodeInfo2 = nodeInfo = i >= nodeInfos.size() ? null : nodeInfos.get(i);
            if (hostname == null) {
                if (nodeInfo != null) {
                    hostname = nodeInfo.hostname();
                } else {
                    LOGGER.debug("Hostname is for nodesExt[{}] is not available, falling back to origin.", (Object)i);
                    hostname = this.origin;
                }
            }
            Map<ServiceType, Integer> ports = nodesExt.get(i).ports();
            Map<ServiceType, Integer> sslPorts = nodesExt.get(i).sslPorts();
            Map<String, AlternateAddress> aa = nodesExt.get(i).alternateAddresses();
            if (!this.bucketCapabilities.contains((Object)BucketCapabilities.COUCHAPI)) {
                ports.remove((Object)ServiceType.VIEW);
                sslPorts.remove((Object)ServiceType.VIEW);
            }
            if (nodeInfo == null) {
                ports.remove((Object)ServiceType.BINARY);
                sslPorts.remove((Object)ServiceType.BINARY);
            }
            converted.add(new DefaultNodeInfo(hostname, ports, sslPorts, aa));
        }
        return converted;
    }

    @Override
    public String uuid() {
        return this.uuid;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public BucketNodeLocator locator() {
        return this.locator;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public String streamingUri() {
        return this.streamingUri;
    }

    @Override
    public List<NodeInfo> nodes() {
        return this.nodeInfo;
    }

    @Override
    public String password() {
        return this.password;
    }

    @Override
    public BucketConfig password(String password) {
        this.password = password;
        return this;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public BucketConfig username(String username) {
        this.username = username;
        return this;
    }

    @Override
    public String useAlternateNetwork() {
        return this.useAlternateNetwork;
    }

    @Override
    public void useAlternateNetwork(String useAlternateNetwork) {
        this.useAlternateNetwork = useAlternateNetwork;
        for (NodeInfo node : this.nodes()) {
            node.useAlternateNetwork(useAlternateNetwork);
        }
    }

    @Override
    public boolean serviceEnabled(ServiceType type) {
        return (this.enabledServices & 1 << type.ordinal()) != 0;
    }

    @Override
    public List<BucketCapabilities> capabilities() {
        return this.bucketCapabilities;
    }
}

