/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.config;

import java.util.Comparator;
import java.util.Objects;

public class BucketConfigRevision
implements Comparable<BucketConfigRevision> {
    private static final Comparator<BucketConfigRevision> comparator = Comparator.comparing(BucketConfigRevision::epoch).thenComparing(BucketConfigRevision::rev);
    private final long epoch;
    private final long rev;

    public BucketConfigRevision(long epoch, long rev) {
        if (rev < 0L) {
            throw new IllegalArgumentException("rev must be non-negative");
        }
        this.epoch = Math.max(0L, epoch);
        this.rev = rev;
    }

    public boolean newerThan(BucketConfigRevision other) {
        return this.compareTo(other) > 0;
    }

    public long epoch() {
        return this.epoch;
    }

    public long rev() {
        return this.rev;
    }

    @Override
    public int compareTo(BucketConfigRevision o) {
        return comparator.compare(this, o);
    }

    public String toString() {
        return this.epoch + "." + this.rev;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BucketConfigRevision that = (BucketConfigRevision)o;
        return this.epoch == that.epoch && this.rev == that.rev;
    }

    public int hashCode() {
        return Objects.hash(this.epoch, this.rev);
    }
}

