/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.config;

import com.couchbase.client.dcp.core.CouchbaseException;
import com.couchbase.client.dcp.core.config.AlternateAddress;
import com.couchbase.client.dcp.core.config.ConfigurationException;
import com.couchbase.client.dcp.core.config.NodeInfo;
import com.couchbase.client.dcp.core.service.ServiceType;
import com.couchbase.client.dcp.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.dcp.deps.com.fasterxml.jackson.annotation.JsonProperty;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DefaultNodeInfo
implements NodeInfo {
    private final String hostname;
    private final Map<ServiceType, Integer> directServices;
    private final Map<ServiceType, Integer> sslServices;
    private final Map<String, AlternateAddress> alternateAddresses;
    private int configPort;
    private volatile String useAlternateNetwork;

    @JsonCreator
    public DefaultNodeInfo(@JsonProperty(value="couchApiBase") String viewUri, @JsonProperty(value="hostname") String hostname, @JsonProperty(value="ports") Map<String, Integer> ports, @JsonProperty(value="alternateAddresses") Map<String, AlternateAddress> alternateAddresses) {
        if (hostname == null) {
            throw new CouchbaseException(new IllegalArgumentException("NodeInfo hostname cannot be null"));
        }
        this.alternateAddresses = alternateAddresses == null ? Collections.emptyMap() : alternateAddresses;
        this.hostname = this.trimPort(hostname);
        this.directServices = this.parseDirectServices(viewUri, ports);
        this.sslServices = new HashMap<ServiceType, Integer>();
    }

    public DefaultNodeInfo(String hostname, Map<ServiceType, Integer> direct, Map<ServiceType, Integer> ssl, Map<String, AlternateAddress> alternateAddresses) {
        if (hostname == null) {
            throw new CouchbaseException(new IllegalArgumentException("NodeInfo hostname cannot be null"));
        }
        this.hostname = hostname;
        this.directServices = direct;
        this.sslServices = ssl;
        this.alternateAddresses = alternateAddresses == null ? Collections.emptyMap() : alternateAddresses;
    }

    @Override
    public String hostname() {
        return this.hostname;
    }

    @Override
    public Map<ServiceType, Integer> services() {
        return this.directServices;
    }

    @Override
    public Map<ServiceType, Integer> sslServices() {
        return this.sslServices;
    }

    @Override
    public Map<String, AlternateAddress> alternateAddresses() {
        return this.alternateAddresses;
    }

    private Map<ServiceType, Integer> parseDirectServices(String viewUri, Map<String, Integer> input) {
        HashMap<ServiceType, Integer> services = new HashMap<ServiceType, Integer>();
        for (Map.Entry<String, Integer> entry : input.entrySet()) {
            String type = entry.getKey();
            Integer port = entry.getValue();
            if (!type.equals("direct")) continue;
            services.put(ServiceType.BINARY, port);
        }
        services.put(ServiceType.CONFIG, this.configPort);
        if (viewUri != null) {
            try {
                services.put(ServiceType.VIEW, new URL(viewUri).getPort());
            }
            catch (MalformedURLException ex) {
                throw new ConfigurationException("Could not parse VIEW URL.", ex);
            }
        }
        return services;
    }

    private String trimPort(String hostname) {
        String[] parts = hostname.split(":");
        this.configPort = Integer.parseInt(parts[parts.length - 1]);
        if (parts.length > 2) {
            String assembledHost = "";
            for (int i = 0; i < parts.length - 1; ++i) {
                assembledHost = assembledHost + parts[i];
                if (parts[i].endsWith("]")) break;
                assembledHost = assembledHost + ":";
            }
            if (assembledHost.startsWith("[") && assembledHost.endsWith("]")) {
                return assembledHost.substring(1, assembledHost.length() - 1);
            }
            return assembledHost;
        }
        return parts[0];
    }

    @Override
    public String useAlternateNetwork() {
        return this.useAlternateNetwork;
    }

    @Override
    public void useAlternateNetwork(String useAlternateNetwork) {
        this.useAlternateNetwork = useAlternateNetwork;
    }

    public String toString() {
        return "DefaultNodeInfo{, hostname=" + this.hostname + ", directServices=" + this.directServices + ", sslServices=" + this.sslServices + ", alternateAddresses=" + this.alternateAddresses + ", configPort=" + this.configPort + ", useAlternateNetwork=" + this.useAlternateNetwork + '}';
    }
}

