/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.security.sasl;

import com.couchbase.client.dcp.core.security.sasl.ShaSaslClientFactory;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class Sasl {
    private static ShaSaslClientFactory SASL_FACTORY = new ShaSaslClientFactory();

    public static SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        boolean enableScram = Boolean.parseBoolean(System.getProperty("com.couchbase.scramEnabled", "true"));
        for (String mech : mechanisms) {
            String[] mechs = new String[]{mech};
            SaslClient client = javax.security.sasl.Sasl.createSaslClient(mechs, authorizationId, protocol, serverName, props, cbh);
            if (client == null && enableScram) {
                client = SASL_FACTORY.createSaslClient(mechs, authorizationId, protocol, serverName, props, cbh);
            }
            if (client == null) continue;
            return client;
        }
        return null;
    }
}

