/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Base64 {
    private static final char[] CODE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    private Base64() {
    }

    public static String encode(byte[] input) {
        ByteArrayInputStream in = new ByteArrayInputStream(input);
        StringBuilder sb = new StringBuilder();
        try {
            while (Base64.encodeChunk(sb, in)) {
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return sb.toString();
    }

    public static byte[] decode(String input) {
        ByteArrayInputStream in = new ByteArrayInputStream(input.getBytes());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            while (Base64.decodeChunk(out, in)) {
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return out.toByteArray();
    }

    private static void encodeRest(StringBuilder out, byte[] s, int num) {
        long val;
        if (num == 2) {
            int v1 = s[0] & 0xFF;
            int v2 = s[1] & 0xFF;
            val = v1 << 16 | v2 << 8;
        } else {
            int v1 = s[0] & 0xFF;
            val = v1 << 16;
        }
        out.append(CODE[(int)(val >>> 18 & 0x3FL)]);
        out.append(CODE[(int)(val >>> 12 & 0x3FL)]);
        if (num == 2) {
            out.append(CODE[(int)(val >>> 6 & 0x3FL)]);
        } else {
            out.append('=');
        }
        out.append('=');
    }

    private static void encodeTriplet(StringBuilder out, byte[] s) {
        int v1 = s[0] & 0xFF;
        int v2 = s[1] & 0xFF;
        int v3 = s[2] & 0xFF;
        int val = v1 << 16 | v2 << 8 | v3;
        out.append(CODE[val >>> 18 & 0x3F]);
        out.append(CODE[val >>> 12 & 0x3F]);
        out.append(CODE[val >>> 6 & 0x3F]);
        out.append(CODE[val & 0x3F]);
    }

    private static boolean encodeChunk(StringBuilder out, InputStream in) throws IOException {
        byte[] s = new byte[3];
        int num = in.read(s);
        switch (num) {
            case 3: {
                Base64.encodeTriplet(out, s);
                return true;
            }
            case 1: 
            case 2: {
                Base64.encodeRest(out, s, num);
            }
            case -1: {
                return false;
            }
        }
        throw new AssertionError((Object)("Invalid length! " + num));
    }

    private static byte getByte(byte val) {
        for (byte ii = 0; ii < CODE.length; ii = (byte)(ii + 1)) {
            if (CODE[ii] != val) continue;
            return ii;
        }
        throw new IllegalAccessError();
    }

    private static boolean decodeChunk(ByteArrayOutputStream out, InputStream in) throws IOException {
        byte[] s = new byte[4];
        int num = in.read(s);
        if (num == -1) {
            return false;
        }
        int len = 3;
        int val = 0;
        val |= Base64.getByte(s[0]) << 18;
        val |= Base64.getByte(s[1]) << 12;
        if (s[2] == 61) {
            --len;
        } else {
            val |= Base64.getByte(s[2]) << 6;
        }
        if (s[3] == 61) {
            --len;
        } else {
            val |= Base64.getByte(s[3]);
        }
        out.write(val >>> 16 & 0xFF);
        if (len > 1) {
            out.write(val >>> 8 & 0xFF);
        }
        if (len > 2) {
            out.write(val & 0xFF);
        }
        return len == 3;
    }
}

