/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.highlevel;

import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.highlevel.DatabaseChangeListener;
import com.couchbase.client.dcp.highlevel.DocumentChange;
import com.couchbase.client.dcp.highlevel.StreamOffset;
import com.couchbase.client.dcp.highlevel.internal.CollectionsManifest;
import com.couchbase.client.dcp.highlevel.internal.FlowControlReceipt;
import com.couchbase.client.dcp.message.DcpMutationMessage;

public class Mutation
extends DocumentChange {
    private final int flags;
    private final int expiry;
    private final int lockTime;

    public Mutation(ByteBuf byteBuf, CollectionsManifest.CollectionInfo collectionInfo, String key, FlowControlReceipt receipt, StreamOffset offset) {
        super(byteBuf, collectionInfo, key, receipt, offset);
        this.flags = DcpMutationMessage.flags(byteBuf);
        this.expiry = DcpMutationMessage.expiry(byteBuf);
        this.lockTime = DcpMutationMessage.lockTime(byteBuf);
    }

    public int getExpiry() {
        return this.expiry;
    }

    public int getLockTime() {
        return this.lockTime;
    }

    public int getFlagsAsInt() {
        return this.flags;
    }

    public boolean isJson() {
        int commonFlags = this.flags >> 24;
        if (commonFlags == 0) {
            return this.flags == 0;
        }
        return (commonFlags & 0xF) == 2;
    }

    @Override
    public void dispatch(DatabaseChangeListener listener) {
        listener.onMutation(this);
    }
}

