/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.highlevel;

import com.couchbase.client.dcp.highlevel.SnapshotMarker;
import java.util.Objects;

public class StreamOffset {
    private final long vbuuid;
    private final long seqno;
    private final SnapshotMarker snapshot;
    private final long collectionsManifestUid;
    public static final StreamOffset ZERO = new StreamOffset(0L, 0L, SnapshotMarker.NONE, 0L);

    public StreamOffset(long vbuuid, long seqno, SnapshotMarker snapshot, long collectionsManifestUid) {
        if (Long.compareUnsigned(seqno, snapshot.getStartSeqno()) < 0 || Long.compareUnsigned(seqno, snapshot.getEndSeqno()) > 0) {
            throw new IllegalArgumentException("Sequence number " + seqno + " is not within snapshot " + snapshot);
        }
        this.vbuuid = vbuuid;
        this.seqno = seqno;
        this.snapshot = Objects.requireNonNull(snapshot);
        this.collectionsManifestUid = collectionsManifestUid;
    }

    public long getVbuuid() {
        return this.vbuuid;
    }

    public long getSeqno() {
        return this.seqno;
    }

    public SnapshotMarker getSnapshot() {
        return this.snapshot;
    }

    public long getCollectionsManifestUid() {
        return this.collectionsManifestUid;
    }

    public String toString() {
        return this.vbuuid + "@" + this.seqno + "m" + this.collectionsManifestUid + this.snapshot;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamOffset that = (StreamOffset)o;
        return this.vbuuid == that.vbuuid && this.seqno == that.seqno && this.collectionsManifestUid == that.collectionsManifestUid && this.snapshot.equals(that.snapshot);
    }

    public int hashCode() {
        return Objects.hash(this.vbuuid, this.seqno, this.collectionsManifestUid);
    }
}

