/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.message;

import com.couchbase.client.dcp.message.DataType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ContentAndXattrs {
    private final Map<String, String> xattrs;
    private final byte[] content;

    public ContentAndXattrs(byte[] content, Map<String, String> xattrs) {
        this.content = Objects.requireNonNull(content);
        this.xattrs = Objects.requireNonNull(xattrs);
    }

    public byte[] content() {
        return this.content;
    }

    public Map<String, String> xattrs() {
        return this.xattrs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ContentAndXattrs parse(byte dataType, byte[] uncompressedContent) {
        if (!DataType.contains(dataType, DataType.XATTR)) {
            return new ContentAndXattrs(uncompressedContent, Collections.emptyMap());
        }
        try (DataInputStream dataInput = new DataInputStream(new ByteArrayInputStream(uncompressedContent));){
            int keyAndValueLen;
            HashMap<String, String> xattrs = new HashMap<String, String>();
            int xattrsLen = dataInput.readInt();
            for (int bytesRead = 0; bytesRead < xattrsLen; bytesRead += 4 + keyAndValueLen) {
                keyAndValueLen = dataInput.readInt();
                String key = ContentAndXattrs.readNullTerminatedUtf8String(dataInput);
                String value = ContentAndXattrs.readNullTerminatedUtf8String(dataInput);
                xattrs.put(key, value);
            }
            int contentStart = 4 + xattrsLen;
            byte[] content = new byte[uncompressedContent.length - contentStart];
            System.arraycopy(uncompressedContent, contentStart, content, 0, content.length);
            ContentAndXattrs contentAndXattrs = new ContentAndXattrs(content, xattrs);
            return contentAndXattrs;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to parse extended attributes", e);
        }
    }

    private static String readNullTerminatedUtf8String(DataInput di) throws IOException {
        byte b;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        while ((b = di.readByte()) != 0) {
            buffer.write(b);
        }
        return buffer.toString("UTF-8");
    }
}

