/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.message;

import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.dcp.message.SnapshotMarkerFlags;

public enum DcpSnapshotMarkerRequest {


    public static boolean is(ByteBuf buffer) {
        return buffer.getByte(0) == -128 && buffer.getByte(1) == 86;
    }

    public static int flags(ByteBuf buffer) {
        return MessageUtil.getExtras(buffer).getInt(16);
    }

    public static boolean memory(ByteBuf buffer) {
        return SnapshotMarkerFlags.MEMORY.isSet(DcpSnapshotMarkerRequest.flags(buffer));
    }

    public static boolean disk(ByteBuf buffer) {
        return SnapshotMarkerFlags.DISK.isSet(DcpSnapshotMarkerRequest.flags(buffer));
    }

    public static boolean checkpoint(ByteBuf buffer) {
        return SnapshotMarkerFlags.CHECKPOINT.isSet(DcpSnapshotMarkerRequest.flags(buffer));
    }

    public static boolean ack(ByteBuf buffer) {
        return SnapshotMarkerFlags.ACK.isSet(DcpSnapshotMarkerRequest.flags(buffer));
    }

    public static long startSeqno(ByteBuf buffer) {
        return MessageUtil.getExtras(buffer).getLong(0);
    }

    public static long endSeqno(ByteBuf buffer) {
        return MessageUtil.getExtras(buffer).getLong(8);
    }

    public static String toString(ByteBuf buffer) {
        return "SnapshotMarker [vbid: " + DcpSnapshotMarkerRequest.partition(buffer) + ", flags: " + String.format("0x%02x", DcpSnapshotMarkerRequest.flags(buffer)) + ", start: " + DcpSnapshotMarkerRequest.startSeqno(buffer) + ", end: " + DcpSnapshotMarkerRequest.endSeqno(buffer) + "]";
    }

    public static int partition(ByteBuf buffer) {
        return MessageUtil.getVbucket(buffer);
    }
}

