/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.message;

import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.dcp.message.StreamEndReason;

public enum DcpStreamEndMessage {


    public static boolean is(ByteBuf buffer) {
        return buffer.getByte(0) == -128 && buffer.getByte(1) == 85;
    }

    public static int vbucket(ByteBuf buffer) {
        return MessageUtil.getVbucket(buffer);
    }

    public static StreamEndReason reason(ByteBuf buffer) {
        int flags = MessageUtil.getExtras(buffer).getInt(0);
        return StreamEndReason.of(flags);
    }

    public static String getReasonAsString(ByteBuf buffer) {
        int reasonCode = MessageUtil.getExtras(buffer).getInt(0);
        try {
            return StreamEndReason.of(reasonCode).name();
        }
        catch (IllegalArgumentException e) {
            return String.valueOf(reasonCode);
        }
    }
}

