/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.transport.netty;

import com.couchbase.client.dcp.config.DcpControl;
import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.dcp.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.dcp.message.DcpControlRequest;
import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.dcp.message.ResponseStatus;
import com.couchbase.client.dcp.transport.netty.ConnectInterceptingHandler;
import com.couchbase.client.dcp.transport.netty.DcpConnectHandler;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcpControlHandler
extends ConnectInterceptingHandler<ByteBuf> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DcpControlHandler.class);
    private Iterator<Map.Entry<String, String>> controlSettings;
    private final DcpControl dcpControl;

    DcpControlHandler(DcpControl dcpControl) {
        this.dcpControl = dcpControl;
    }

    private void negotiate(ChannelHandlerContext ctx) {
        if (this.controlSettings.hasNext()) {
            Map.Entry<String, String> setting = this.controlSettings.next();
            LOGGER.debug("Negotiating DCP Control {}: {}", (Object)setting.getKey(), (Object)setting.getValue());
            ByteBuf request = ctx.alloc().buffer();
            DcpControlRequest.init(request);
            DcpControlRequest.key(setting.getKey(), request);
            DcpControlRequest.value(Unpooled.copiedBuffer(setting.getValue(), StandardCharsets.UTF_8), request);
            ctx.writeAndFlush(request);
        } else {
            this.originalPromise().setSuccess();
            ctx.pipeline().remove(this);
            ctx.fireChannelActive();
            LOGGER.debug("Negotiated all DCP Control settings against Node {}", (Object)ctx.channel().remoteAddress());
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.controlSettings = this.dcpControl.getControls(DcpConnectHandler.getServerVersion(ctx.channel())).entrySet().iterator();
        this.negotiate(ctx);
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        ResponseStatus status = MessageUtil.getResponseStatus(msg);
        if (status.isSuccess()) {
            this.negotiate(ctx);
        } else {
            this.originalPromise().setFailure(new IllegalStateException("Could not configure DCP Controls: " + status));
        }
    }
}

