/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.transport.netty;

import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBufHolder;
import com.couchbase.client.dcp.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.dcp.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.dcp.deps.io.netty.handler.logging.LogLevel;
import com.couchbase.client.dcp.deps.io.netty.handler.logging.LoggingHandler;
import com.couchbase.client.dcp.message.MessageUtil;

@ChannelHandler.Sharable
public class DcpLoggingHandler
extends LoggingHandler {
    public DcpLoggingHandler() {
    }

    public DcpLoggingHandler(LogLevel level) {
        super(level);
    }

    public DcpLoggingHandler(Class<?> clazz) {
        super(clazz);
    }

    public DcpLoggingHandler(Class<?> clazz, LogLevel level) {
        super(clazz, level);
    }

    public DcpLoggingHandler(String name) {
        super(name);
    }

    public DcpLoggingHandler(String name, LogLevel level) {
        super(name, level);
    }

    @Override
    protected String format(ChannelHandlerContext ctx, String eventName, Object arg) {
        if (arg instanceof ByteBuf) {
            return this.formatDcpPacket(ctx, eventName, (ByteBuf)arg);
        }
        if (arg instanceof ByteBufHolder) {
            return this.formatDcpPacket(ctx, eventName, ((ByteBufHolder)arg).content());
        }
        return super.format(ctx, eventName, arg);
    }

    private String formatDcpPacket(ChannelHandlerContext ctx, String eventName, ByteBuf msg) {
        if (msg.readableBytes() == 0) {
            return ctx.channel() + " " + eventName + ": 0B";
        }
        return ctx.channel() + " " + eventName + ":\n" + MessageUtil.humanize(msg);
    }
}

