/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp;

import com.couchbase.client.dcp.Authenticator;
import com.couchbase.client.dcp.Credentials;
import com.couchbase.client.dcp.CredentialsProvider;
import com.couchbase.client.dcp.conductor.DcpChannel;
import com.couchbase.client.dcp.config.HostAndPort;
import com.couchbase.client.dcp.deps.io.netty.channel.ChannelPipeline;
import com.couchbase.client.dcp.transport.netty.AuthHandler;
import java.util.Objects;

public class PasswordAuthenticator
implements Authenticator {
    private final CredentialsProvider credentialsProvider;

    public PasswordAuthenticator(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = Objects.requireNonNull(credentialsProvider);
    }

    @Override
    public void authKeyValueConnection(ChannelPipeline pipeline) {
        HostAndPort remoteAddress = DcpChannel.getHostAndPort(pipeline.channel());
        Credentials credentials = this.credentialsProvider.get(remoteAddress);
        pipeline.addLast(new AuthHandler(credentials));
    }
}

