/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.security.sasl;

import com.couchbase.client.dcp.core.security.sasl.ScramSaslClientFactory;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;

public class CouchbaseSaslClientFactory
implements SaslClientFactory {
    private static final SaslClientFactory SCRAM_FACTORY = new ScramSaslClientFactory();

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        SaslClient client = SCRAM_FACTORY.createSaslClient(mechanisms, authorizationId, protocol, serverName, props, cbh);
        if (client == null) {
            client = Sasl.createSaslClient(mechanisms, authorizationId, protocol, serverName, props, cbh);
        }
        return client;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        return new String[]{ScramSaslClientFactory.Mode.SCRAM_SHA512.mech(), ScramSaslClientFactory.Mode.SCRAM_SHA256.mech(), ScramSaslClientFactory.Mode.SCRAM_SHA1.mech(), "CRAM-MD5", "PLAIN"};
    }
}

