/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.events;

import com.couchbase.client.dcp.conductor.DcpChannel;
import com.couchbase.client.dcp.config.HostAndPort;
import com.couchbase.client.dcp.deps.com.fasterxml.jackson.databind.json.JsonMapper;
import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.deps.io.netty.channel.Channel;
import com.couchbase.client.dcp.events.Tracer;
import com.couchbase.client.dcp.highlevel.internal.CollectionIdAndKey;
import com.couchbase.client.dcp.message.DcpDeletionMessage;
import com.couchbase.client.dcp.message.DcpExpirationMessage;
import com.couchbase.client.dcp.message.DcpMutationMessage;
import com.couchbase.client.dcp.message.DcpStreamEndMessage;
import com.couchbase.client.dcp.message.HelloFeature;
import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.dcp.metrics.LogLevel;
import com.couchbase.client.dcp.transport.netty.DcpConnectHandler;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingTracer
implements Tracer {
    private static final Logger log = LoggerFactory.getLogger((String)"com.couchbase.client.dcp.trace");
    private static final JsonMapper mapper = new JsonMapper();
    private final LogLevel level;
    private final Predicate<String> documentIdMatcher;

    public LoggingTracer(LogLevel level, Predicate<String> documentIdIsInteresting) {
        this.level = Objects.requireNonNull(level);
        this.documentIdMatcher = documentIdIsInteresting == null ? s -> true : documentIdIsInteresting;
    }

    private boolean disabled() {
        return !this.level.isEnabled(log);
    }

    @Override
    public void onConnectionOpen(String channel) {
        if (this.disabled()) {
            return;
        }
        LinkedHashMap<String, String> message = new LinkedHashMap<String, String>();
        message.put("event", "CONNECTION_OPEN");
        message.put("channel", channel);
        this.log(message);
    }

    @Override
    public void onConnectionClose(String channel) {
        if (this.disabled()) {
            return;
        }
        LinkedHashMap<String, String> message = new LinkedHashMap<String, String>();
        message.put("event", "CONNECTION_CLOSE");
        message.put("channel", channel);
        this.log(message);
    }

    @Override
    public void onStreamStart(HostAndPort address, int partition, long partitionUuid, long startSeqno, long endSeqno, long snapshotStartSeqno, long snapshotEndSeqno, Map<String, Object> value) {
        if (this.disabled()) {
            return;
        }
        LinkedHashMap<String, Object> message = new LinkedHashMap<String, Object>();
        message.put("event", "STREAM_START");
        message.put("address", address.format());
        message.put("partition", partition);
        message.put("partitionUuid", partitionUuid);
        message.put("startSeqno", startSeqno);
        message.put("endSeqno", endSeqno);
        message.put("snapshotStartSeqno", snapshotStartSeqno);
        message.put("snapshotEndSeqno", snapshotEndSeqno);
        message.put("value", value);
        this.log(message);
    }

    @Override
    public void onStreamStartFailed(HostAndPort address, int partition, String cause) {
        if (this.disabled()) {
            return;
        }
        LinkedHashMap<String, Object> message = new LinkedHashMap<String, Object>();
        message.put("event", "STREAM_START_FAILED");
        message.put("address", address.format());
        message.put("partition", partition);
        message.put("cause", cause);
        this.log(message);
    }

    @Override
    public void onDataEvent(ByteBuf buf, Channel channel) {
        if (this.disabled()) {
            return;
        }
        boolean collectionsEnabled = DcpConnectHandler.getFeatures(channel).contains((Object)HelloFeature.COLLECTIONS);
        CollectionIdAndKey idAndKey = MessageUtil.getCollectionIdAndKey(buf, collectionsEnabled);
        if (!this.documentIdMatcher.test(idAndKey.key())) {
            return;
        }
        String type = DcpMutationMessage.is(buf) ? "mutation" : (DcpDeletionMessage.is(buf) ? "deletion" : (DcpExpirationMessage.is(buf) ? "expiration" : "unrecognized"));
        LinkedHashMap<String, Object> message = new LinkedHashMap<String, Object>();
        message.put("event", "DOCUMENT_CHANGE");
        message.put("type", type);
        message.put("id", idAndKey.key());
        message.put("collection", idAndKey.collectionId());
        message.put("partition", MessageUtil.getVbucket(buf));
        message.put("seqno", DcpMutationMessage.bySeqno(buf));
        message.put("rev", DcpMutationMessage.revisionSeqno(buf));
        message.put("cas", DcpMutationMessage.cas(buf));
        this.log(message);
    }

    @Override
    public void onControlEvent(ByteBuf buf, Channel channel) {
        if (this.disabled()) {
            return;
        }
        if (!DcpStreamEndMessage.is(buf)) {
            return;
        }
        LinkedHashMap<String, Object> message = new LinkedHashMap<String, Object>();
        message.put("event", "STREAM_END");
        message.put("address", DcpChannel.getHostAndPort(channel).format());
        message.put("partition", MessageUtil.getVbucket(buf));
        message.put("reason", DcpStreamEndMessage.reason(buf).name());
        this.log(message);
    }

    private void log(Object message) {
        try {
            this.level.log(log, "{}", (Object)mapper.writeValueAsString(message));
        }
        catch (Exception e) {
            this.level.log(log, "{}", message);
        }
    }
}

