/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.highlevel.internal;

import com.couchbase.client.dcp.core.utils.CbCollections;
import com.couchbase.client.dcp.core.utils.DefaultObjectMapper;
import com.couchbase.client.dcp.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.stream.Collectors;

public class CollectionsManifest {
    public static final CollectionsManifest DEFAULT = CollectionsManifest.defaultManifest();
    private final long id;
    private final Map<Long, ScopeInfo> scopesById;
    private final Map<Long, CollectionInfo> collectionsById;

    private static <K, V> Map<K, V> copyToUnmodifiableMap(Map<K, V> map) {
        return Collections.unmodifiableMap(new HashMap<K, V>(map));
    }

    private CollectionsManifest(long manifestId, Map<Long, ScopeInfo> scopesById, Map<Long, CollectionInfo> collectionsById) {
        this.id = manifestId;
        this.scopesById = CollectionsManifest.copyToUnmodifiableMap(scopesById);
        this.collectionsById = CollectionsManifest.copyToUnmodifiableMap(collectionsById);
    }

    private static CollectionsManifest defaultManifest() {
        ScopeInfo defaultScope = ScopeInfo.DEFAULT;
        ScopeInfo defaultCollection = ScopeInfo.DEFAULT;
        return new CollectionsManifest(0L, CbCollections.mapOf(defaultScope.id(), defaultScope), CbCollections.mapOf(defaultCollection.id(), new CollectionInfo(defaultScope, defaultCollection.id(), defaultCollection.name(), null)));
    }

    public CollectionsManifest withManifestId(long newManifestId) {
        return new CollectionsManifest(newManifestId, this.scopesById, this.collectionsById);
    }

    public CollectionsManifest withScope(long newManifestId, long newScopeId, String newScopeName) {
        HashMap<Long, ScopeInfo> newScopeMap = new HashMap<Long, ScopeInfo>(this.scopesById);
        newScopeMap.put(newScopeId, new ScopeInfo(newScopeId, newScopeName));
        return new CollectionsManifest(newManifestId, newScopeMap, this.collectionsById);
    }

    public CollectionsManifest withoutScope(long newManifestId, long doomedScopeId) {
        HashMap<Long, ScopeInfo> newScopeMap = new HashMap<Long, ScopeInfo>(this.scopesById);
        newScopeMap.remove(doomedScopeId);
        Map<Long, CollectionInfo> newCollectionMap = this.collectionsById.entrySet().stream().filter(e -> ((CollectionInfo)e.getValue()).scope().id() != doomedScopeId).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new CollectionsManifest(newManifestId, newScopeMap, newCollectionMap);
    }

    public CollectionsManifest withCollection(long newManifestId, long scopeId, long collectionId, String collectionName, Long maxTtl) {
        ScopeInfo scopeIdAndName = this.scopesById.get(scopeId);
        if (scopeIdAndName == null) {
            throw new IllegalStateException("Unrecognized scope ID: " + scopeId);
        }
        HashMap<Long, CollectionInfo> newCollectionMap = new HashMap<Long, CollectionInfo>(this.collectionsById);
        newCollectionMap.put(collectionId, new CollectionInfo(scopeIdAndName, collectionId, collectionName, maxTtl));
        return new CollectionsManifest(newManifestId, this.scopesById, newCollectionMap);
    }

    public CollectionsManifest withoutCollection(long newManifestId, long id) {
        Map<Long, CollectionInfo> newCollectionMap = this.collectionsById.entrySet().stream().filter(e -> ((CollectionInfo)e.getValue()).id() != id).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new CollectionsManifest(newManifestId, this.scopesById, newCollectionMap);
    }

    public CollectionInfo getCollection(long id) {
        return this.collectionsById.get(id);
    }

    public CollectionInfo getCollection(String name) {
        String[] split = name.split("\\.", -1);
        if (split.length != 2) {
            throw new IllegalArgumentException("Collection name must be qualified by scope, like: myScope.myCollection");
        }
        String scope = split[0];
        String collection = split[1];
        return this.collectionsById.values().stream().filter(c -> c.name().equals(collection)).filter(c -> c.scope().name().equals(scope)).findFirst().orElse(null);
    }

    public ScopeInfo getScope(String name) {
        return this.scopesById.values().stream().filter(s -> s.name().equals(name)).findFirst().orElse(null);
    }

    public long getId() {
        return this.id;
    }

    public String toString() {
        return "CollectionsManifest{id=" + this.id + ", scopesById=" + this.scopesById + ", collectionsById=" + this.collectionsById + '}';
    }

    public static CollectionsManifest fromJson(byte[] jsonBytes) throws IOException {
        ManifestJson manifestBinder = DefaultObjectMapper.readValue(jsonBytes, ManifestJson.class);
        return manifestBinder.build();
    }

    private static long parseId(String id) {
        return Long.parseUnsignedLong(id, 16);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class CollectionJson {
        public String uid;
        public String name;
        public Long max_ttl;

        private CollectionJson() {
        }

        private CollectionsManifest build(CollectionsManifest m, long manifestId, long scopeId) {
            return m.withCollection(manifestId, scopeId, CollectionsManifest.parseId(this.uid), this.name, this.max_ttl);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class ScopeJson {
        public String uid;
        public String name;
        public List<CollectionJson> collections;

        private ScopeJson() {
        }

        private CollectionsManifest build(CollectionsManifest m, long manifestId) {
            long scopeId = CollectionsManifest.parseId(this.uid);
            m = m.withScope(manifestId, scopeId, this.name);
            for (CollectionJson c : this.collections) {
                m = c.build(m, manifestId, scopeId);
            }
            return m;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class ManifestJson {
        public String uid;
        public List<ScopeJson> scopes;

        private ManifestJson() {
        }

        private CollectionsManifest build() {
            long manifestId = CollectionsManifest.parseId(this.uid);
            CollectionsManifest m = new CollectionsManifest(manifestId, Collections.emptyMap(), Collections.emptyMap());
            for (ScopeJson s : this.scopes) {
                m = s.build(m, manifestId);
            }
            return m;
        }
    }

    public static class CollectionInfo {
        private final ScopeInfo scope;
        private final long id;
        private final String name;
        private final OptionalLong maxTtl;

        public CollectionInfo(ScopeInfo scope, long id, String name, Long maxTtl) {
            this.id = id;
            this.name = Objects.requireNonNull(name);
            this.scope = Objects.requireNonNull(scope);
            this.maxTtl = maxTtl == null ? OptionalLong.empty() : OptionalLong.of(maxTtl);
        }

        public ScopeInfo scope() {
            return this.scope;
        }

        public long id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public OptionalLong maxTtl() {
            return this.maxTtl;
        }

        public String toString() {
            return "CollectionInfo{scope=" + this.scope + ", id=" + this.id + ", name='" + this.name + '\'' + ", maxTtl=" + this.maxTtl + '}';
        }
    }

    public static class ScopeInfo {
        public static final ScopeInfo DEFAULT = new ScopeInfo(0L, "_default");
        private final long id;
        private final String name;

        public ScopeInfo(long id, String name) {
            this.id = id;
            this.name = Objects.requireNonNull(name);
        }

        public long id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            return this.id + ":" + this.name;
        }
    }
}

