/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.highlevel.internal;

import com.couchbase.client.dcp.core.utils.UnsignedLEB128;
import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.highlevel.internal.CollectionIdAndKey;
import com.couchbase.client.dcp.message.MessageUtil;
import java.nio.charset.StandardCharsets;

public interface KeyExtractor {
    public static final KeyExtractor COLLECTIONS = event -> {
        ByteBuf keyBuf = MessageUtil.getKey(event);
        return new CollectionIdAndKey(UnsignedLEB128.read(keyBuf), keyBuf.toString(StandardCharsets.UTF_8));
    };
    public static final KeyExtractor NO_COLLECTIONS = event -> CollectionIdAndKey.forDefaultCollection(MessageUtil.getKeyAsString(event));

    public CollectionIdAndKey getCollectionIdAndKey(ByteBuf var1);
}

