/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.message;

import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.dcp.message.OpenConnectionFlag;
import java.nio.charset.StandardCharsets;
import java.util.Set;

public enum DcpOpenConnectionRequest {


    public static boolean is(ByteBuf buffer) {
        return buffer.getByte(0) == -128 && buffer.getByte(1) == 80;
    }

    public static void init(ByteBuf buffer, Set<OpenConnectionFlag> flags) {
        int flagsAsInt = OpenConnectionFlag.encode(flags) | OpenConnectionFlag.PRODUCER.value();
        MessageUtil.initRequest((byte)80, buffer);
        ByteBuf extras = Unpooled.buffer(8);
        MessageUtil.setExtras(extras.writeInt(0).writeInt(flagsAsInt), buffer);
        extras.release();
    }

    public static void connectionName(ByteBuf buffer, String connectionName) {
        int nameLen = connectionName.getBytes(StandardCharsets.UTF_8).length;
        if (nameLen > 200) {
            throw new IllegalArgumentException("DCP connection name must be no longer than 200 UTF-8 bytes, but got " + nameLen + " bytes. Connection name: '" + connectionName + "'");
        }
        MessageUtil.setKey(connectionName, buffer);
    }

    public static ByteBuf connectionName(ByteBuf buffer) {
        return MessageUtil.getKey(buffer);
    }
}

