/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.transport.netty;

import com.couchbase.client.dcp.Credentials;
import com.couchbase.client.dcp.core.endpoint.kv.AuthenticationException;
import com.couchbase.client.dcp.core.logging.RedactableArgument;
import com.couchbase.client.dcp.core.security.sasl.CouchbaseSaslClientFactory;
import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.dcp.deps.io.netty.util.concurrent.Future;
import com.couchbase.client.dcp.deps.io.netty.util.concurrent.GenericFutureListener;
import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.dcp.message.ResponseStatus;
import com.couchbase.client.dcp.message.SaslAuthRequest;
import com.couchbase.client.dcp.message.SaslAuthResponse;
import com.couchbase.client.dcp.message.SaslListMechsRequest;
import com.couchbase.client.dcp.message.SaslListMechsResponse;
import com.couchbase.client.dcp.message.SaslStepRequest;
import com.couchbase.client.dcp.message.SaslStepResponse;
import com.couchbase.client.dcp.transport.netty.ConnectInterceptingHandler;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthHandler
extends ConnectInterceptingHandler<ByteBuf>
implements CallbackHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthHandler.class);
    private final Credentials credentials;
    private SaslClient saslClient;
    private String selectedMechanism;

    public AuthHandler(Credentials credentials) {
        this.credentials = Objects.requireNonNull(credentials);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ByteBuf request = ctx.alloc().buffer();
        SaslListMechsRequest.init(request);
        this.send(ctx, request);
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        if (SaslListMechsResponse.is(msg)) {
            this.handleListMechsResponse(ctx, msg);
        } else if (SaslAuthResponse.is(msg) || SaslStepResponse.is(msg)) {
            this.handleSaslResponse(ctx, msg);
        } else {
            throw new IllegalStateException("Received unexpected packet during SASL exchange! " + MessageUtil.humanize(msg));
        }
    }

    private void handleSaslResponse(ChannelHandlerContext ctx, ByteBuf msg) {
        block7: {
            try {
                ResponseStatus status = MessageUtil.getResponseStatus(msg);
                if (status.isSuccess()) {
                    if (!this.saslClient.isComplete()) {
                        byte[] serverFinal = MessageUtil.getContentAsByteArray(msg);
                        this.saslClient.evaluateChallenge(serverFinal);
                        if (!this.saslClient.isComplete()) {
                            throw new IllegalStateException("SASL exchange incomplete");
                        }
                    }
                    LOGGER.debug("Successfully authenticated against node {}", (Object)ctx.channel().remoteAddress());
                    ctx.pipeline().remove(this);
                    this.originalPromise().setSuccess();
                    ctx.fireChannelActive();
                    break block7;
                }
                if (status == ResponseStatus.AUTH_CONTINUE) {
                    byte[] challenge = MessageUtil.getContentAsByteArray(msg);
                    byte[] challengeResponse = this.saslClient.evaluateChallenge(challenge);
                    ByteBuf request = ctx.alloc().buffer();
                    SaslStepRequest.init(request);
                    SaslStepRequest.mechanism(this.selectedMechanism, request);
                    SaslStepRequest.challengeResponse(challengeResponse, request);
                    this.send(ctx, request);
                    break block7;
                }
                if (status == ResponseStatus.AUTH_ERROR) {
                    throw new AuthenticationException("SASL Authentication Failure");
                }
                throw new AuthenticationException("Unhandled SASL auth status: " + status);
            }
            catch (Throwable t) {
                this.fail(t);
            }
        }
    }

    private void handleListMechsResponse(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        try {
            String remote = ctx.channel().remoteAddress().toString();
            Object[] supportedMechanisms = SaslListMechsResponse.supportedMechs(msg);
            if (supportedMechanisms.length == 0) {
                throw new AuthenticationException("Received empty SASL mechanisms list from server: " + RedactableArgument.system(remote));
            }
            this.saslClient = new CouchbaseSaslClientFactory().createSaslClient((String[])supportedMechanisms, null, "couchbase", remote, null, this);
            if (this.saslClient == null) {
                throw new AuthenticationException("Failed to create a SASL client for any of the negotiated mechanisms: " + Arrays.toString(supportedMechanisms));
            }
            this.selectedMechanism = this.saslClient.getMechanismName();
            LOGGER.debug("Selected SASL mechanism: {}", (Object)this.selectedMechanism);
            byte[] payload = this.saslClient.hasInitialResponse() ? this.saslClient.evaluateChallenge(new byte[0]) : new byte[]{};
            ByteBuf request = ctx.alloc().buffer();
            SaslAuthRequest.init(request);
            SaslAuthRequest.mechanism(this.selectedMechanism, request);
            SaslAuthRequest.challengeResponse(payload, request);
            this.send(ctx, request);
        }
        catch (Throwable t) {
            this.fail(t);
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.credentials.getUsername());
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.credentials.getPassword().toCharArray());
                continue;
            }
            throw new AuthenticationException("SASLClient requested unsupported callback: " + callback);
        }
    }

    private void fail(Throwable cause) {
        this.originalPromise().setFailure(cause);
    }

    private void send(ChannelHandlerContext ctx, ByteBuf request) {
        ctx.writeAndFlush(request).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
            if (!future.isSuccess()) {
                LOGGER.warn("Error during SASL Auth negotiation phase.", future.cause());
                this.fail(future.cause());
            }
        }));
    }
}

