/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.transport.netty;

import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.dcp.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.dcp.deps.io.netty.handler.timeout.IdleStateEvent;
import com.couchbase.client.dcp.deps.io.netty.handler.timeout.IdleStateHandler;
import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.dcp.message.ResponseStatus;
import com.couchbase.client.dcp.transport.netty.DcpMessageHandler;
import com.couchbase.client.dcp.transport.netty.DcpResponse;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientNoopHandler
extends IdleStateHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientNoopHandler.class);

    public ClientNoopHandler(long readerIdleTime, TimeUnit unit) {
        super(readerIdleTime, 0L, 0L, unit);
    }

    @Override
    protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
        LOGGER.debug("Nothing read from channel {} for {} seconds; sending client-side NOOP request.", (Object)ctx.channel(), (Object)TimeUnit.MILLISECONDS.toSeconds(this.getReaderIdleTimeInMillis()));
        ctx.pipeline().get(DcpMessageHandler.class).sendRequest(ClientNoopHandler.newNoopRequest()).addListener(future -> {
            if (future.isSuccess()) {
                DcpResponse dcpResponse = (DcpResponse)future.getNow();
                ByteBuf buffer = dcpResponse.buffer();
                try {
                    ResponseStatus status = dcpResponse.status();
                    if (status.isSuccess()) {
                        LOGGER.debug("Got successful response to client-side NOOP for channel {}", (Object)ctx.channel());
                    }
                    LOGGER.warn("Got error response to client-side NOOP for channel {}: {}", (Object)ctx.channel(), (Object)status);
                }
                finally {
                    buffer.release();
                }
            } else {
                LOGGER.warn("Failed to send client-side NOOP for channel {}", (Object)ctx.channel(), (Object)future.cause());
            }
        });
    }

    private static ByteBuf newNoopRequest() {
        ByteBuf buffer = Unpooled.buffer();
        MessageUtil.initRequest((byte)10, buffer);
        return buffer;
    }
}

