/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.transport.netty;

import com.couchbase.client.dcp.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.dcp.deps.io.netty.channel.ChannelOutboundHandler;
import com.couchbase.client.dcp.deps.io.netty.channel.ChannelPromise;
import com.couchbase.client.dcp.deps.io.netty.channel.ConnectTimeoutException;
import com.couchbase.client.dcp.deps.io.netty.channel.SimpleChannelInboundHandler;
import com.couchbase.client.dcp.deps.io.netty.util.concurrent.Future;
import com.couchbase.client.dcp.deps.io.netty.util.concurrent.GenericFutureListener;
import com.couchbase.client.dcp.transport.netty.HandshakeDeadlineEvent;
import java.net.ConnectException;
import java.net.SocketAddress;

abstract class ConnectInterceptingHandler<T>
extends SimpleChannelInboundHandler<T>
implements ChannelOutboundHandler {
    private ChannelPromise originalPromise;
    private static final String customPortAdvice = "If your seed nodes include a custom port, make sure it's the port of the KV service which defaults to 11210 (or 11207 for TLS).";

    ConnectInterceptingHandler() {
    }

    ChannelPromise originalPromise() {
        return this.originalPromise;
    }

    @Override
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        this.originalPromise = promise;
        ChannelPromise inboundPromise = ctx.newPromise();
        inboundPromise.addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<Void>>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess() && !ConnectInterceptingHandler.this.originalPromise.isDone()) {
                    ConnectInterceptingHandler.this.originalPromise.setFailure(future.cause());
                }
            }
        });
        ctx.connect(remoteAddress, localAddress, inboundPromise);
    }

    @Override
    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.bind(localAddress, promise);
    }

    @Override
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.disconnect(promise);
    }

    @Override
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.close(promise);
    }

    @Override
    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.deregister(promise);
    }

    @Override
    public void read(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        ctx.write(msg, promise);
    }

    @Override
    public void flush(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.originalPromise != null) {
            this.originalPromise.setFailure(cause);
        }
        ctx.fireExceptionCaught(cause);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof HandshakeDeadlineEvent) {
            this.originalPromise().tryFailure(new ConnectTimeoutException("Handshake did not complete before deadline. If your seed nodes include a custom port, make sure it's the port of the KV service which defaults to 11210 (or 11207 for TLS)."));
            ctx.close();
            return;
        }
        ctx.fireUserEventTriggered(evt);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.originalPromise().tryFailure(new ConnectException("Channel became inactive before handshake completed. If your seed nodes include a custom port, make sure it's the port of the KV service which defaults to 11210 (or 11207 for TLS)."));
        ctx.fireChannelInactive();
    }
}

