/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp;

import com.couchbase.client.dcp.core.utils.CbCollections;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public class SecurityConfig {
    private static final boolean DEFAULT_TLS_ENABLED = false;
    private static final boolean DEFAULT_NATIVE_TLS_ENABLED = true;
    private static final boolean DEFAULT_HOSTNAME_VERIFICATION_ENABLED = true;
    private final boolean nativeTlsEnabled;
    private final boolean hostnameVerificationEnabled;
    private final boolean tlsEnabled;
    private final List<X509Certificate> trustCertificates;
    private final TrustManagerFactory trustManagerFactory;

    public static Builder builder() {
        return new Builder();
    }

    private SecurityConfig(Builder builder) {
        this.tlsEnabled = builder.tlsEnabled;
        this.nativeTlsEnabled = builder.nativeTlsEnabled;
        this.trustCertificates = builder.trustCertificates;
        this.trustManagerFactory = builder.trustManagerFactory;
        this.hostnameVerificationEnabled = builder.hostnameVerificationEnabled;
        if (this.tlsEnabled) {
            if (this.trustCertificates != null && this.trustManagerFactory != null) {
                throw new IllegalArgumentException("Either trust certificates or a trust manager factory can be provided, but not both!");
            }
            if ((this.trustCertificates == null || this.trustCertificates.isEmpty()) && this.trustManagerFactory == null) {
                throw new IllegalArgumentException("Either a trust certificate or a trust manager factory must be provided when TLS is enabled!");
            }
        }
    }

    public boolean tlsEnabled() {
        return this.tlsEnabled;
    }

    public boolean hostnameVerificationEnabled() {
        return this.hostnameVerificationEnabled;
    }

    public List<X509Certificate> trustCertificates() {
        return this.trustCertificates;
    }

    public TrustManagerFactory trustManagerFactory() {
        return this.trustManagerFactory;
    }

    public boolean nativeTlsEnabled() {
        return this.nativeTlsEnabled;
    }

    public String toString() {
        return this.exportAsMap().toString();
    }

    Map<String, Object> exportAsMap() {
        LinkedHashMap<String, Object> export = new LinkedHashMap<String, Object>();
        export.put("tlsEnabled", this.tlsEnabled);
        export.put("nativeTlsEnabled", this.nativeTlsEnabled);
        export.put("hostnameVerificationEnabled", this.hostnameVerificationEnabled);
        export.put("hasTrustCertificates", this.trustCertificates != null && !this.trustCertificates.isEmpty());
        export.put("trustManagerFactory", this.trustManagerFactory != null ? this.trustManagerFactory.getClass().getSimpleName() : null);
        return export;
    }

    public static List<X509Certificate> decodeCertificates(List<String> certificates) {
        CertificateFactory cf;
        Objects.requireNonNull(certificates, "Certificates");
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException("Could not instantiate X.509 CertificateFactory", e);
        }
        return certificates.stream().map(c -> {
            try {
                return (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(c.getBytes(StandardCharsets.UTF_8)));
            }
            catch (CertificateException e) {
                throw new IllegalArgumentException("Could not generate certificate from raw input: \"" + c + "\"", e);
            }
        }).collect(Collectors.toList());
    }

    public static class Builder {
        private boolean tlsEnabled = false;
        private boolean nativeTlsEnabled = true;
        private boolean hostnameVerificationEnabled = true;
        private List<X509Certificate> trustCertificates = null;
        private TrustManagerFactory trustManagerFactory = null;

        public SecurityConfig build() {
            return new SecurityConfig(this);
        }

        public Builder enableTls(boolean tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
            return this;
        }

        public Builder enableHostnameVerification(boolean hostnameVerificationEnabled) {
            this.hostnameVerificationEnabled = hostnameVerificationEnabled;
            return this;
        }

        public Builder enableNativeTls(boolean nativeTlsEnabled) {
            this.nativeTlsEnabled = nativeTlsEnabled;
            return this;
        }

        public Builder trustCertificates(List<X509Certificate> certificates) {
            if (CbCollections.isNullOrEmpty(certificates)) {
                throw new IllegalArgumentException("List of X509 Certificates cannot be null or empty");
            }
            this.trustCertificates = certificates;
            return this;
        }

        public Builder trustCertificate(Path certificatePath) {
            Objects.requireNonNull(certificatePath, "CertificatePath");
            StringBuilder contentBuilder = new StringBuilder();
            try {
                Files.lines(certificatePath, StandardCharsets.UTF_8).forEach(s -> contentBuilder.append((String)s).append("\n"));
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Could not read trust certificate from file \"" + certificatePath + "\"", ex);
            }
            return this.trustCertificates(SecurityConfig.decodeCertificates(Collections.singletonList(contentBuilder.toString())));
        }

        public Builder trustManagerFactory(TrustManagerFactory trustManagerFactory) {
            this.trustManagerFactory = Objects.requireNonNull(trustManagerFactory, "TrustManagerFactory");
            return this;
        }

        public Builder trustStore(KeyStore trustStore) {
            Objects.requireNonNull(trustStore, "TrustStore");
            try {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                tmf.init(trustStore);
                return this.trustManagerFactory(tmf);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Could not initialize TrustManagerFactory from TrustStore", ex);
            }
        }

        public Builder trustStore(Path trustStorePath, String trustStorePassword) {
            return this.trustStore(trustStorePath, trustStorePassword, null);
        }

        public Builder trustStore(Path trustStorePath, String trustStorePassword, String trustStoreType) {
            Builder builder;
            block8: {
                Objects.requireNonNull(trustStorePath, "TrustStorePath");
                InputStream trustStoreInputStream = Files.newInputStream(trustStorePath, new OpenOption[0]);
                try {
                    KeyStore store = KeyStore.getInstance(trustStoreType != null ? trustStoreType : KeyStore.getDefaultType());
                    store.load(trustStoreInputStream, trustStorePassword != null ? trustStorePassword.toCharArray() : null);
                    builder = this.trustStore(store);
                    if (trustStoreInputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (trustStoreInputStream != null) {
                            try {
                                trustStoreInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        throw new IllegalArgumentException("Could not initialize TrustStore", ex);
                    }
                }
                trustStoreInputStream.close();
            }
            return builder;
        }
    }
}

