/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.config;

import com.couchbase.client.dcp.core.config.DefaultPartition;
import com.couchbase.client.dcp.core.config.Partition;
import com.couchbase.client.dcp.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.dcp.deps.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CouchbasePartitionInfo {
    private final int numberOfReplicas;
    private final String[] partitionHosts;
    private final List<Partition> partitions;
    private final List<Partition> forwardPartitions;
    private final boolean tainted;

    CouchbasePartitionInfo(@JsonProperty(value="numReplicas") int numberOfReplicas, @JsonProperty(value="serverList") List<String> partitionHosts, @JsonProperty(value="vBucketMap") List<List<Integer>> partitions, @JsonProperty(value="vBucketMapForward") List<List<Integer>> forwardPartitions) {
        this.numberOfReplicas = numberOfReplicas;
        this.partitionHosts = partitionHosts.toArray(new String[partitionHosts.size()]);
        this.partitions = CouchbasePartitionInfo.fromPartitionList(partitions);
        if (forwardPartitions != null && !forwardPartitions.isEmpty()) {
            this.forwardPartitions = CouchbasePartitionInfo.fromPartitionList(forwardPartitions);
            this.tainted = true;
        } else {
            this.forwardPartitions = null;
            this.tainted = false;
        }
    }

    public boolean hasFastForwardMap() {
        return this.forwardPartitions != null;
    }

    public int numberOfReplicas() {
        return this.numberOfReplicas;
    }

    public String[] partitionHosts() {
        return this.partitionHosts;
    }

    public List<Partition> partitions() {
        return this.partitions;
    }

    public List<Partition> forwardPartitions() {
        return this.forwardPartitions;
    }

    public boolean tainted() {
        return this.tainted;
    }

    private static List<Partition> fromPartitionList(List<List<Integer>> input) {
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        if (input == null) {
            return partitions;
        }
        for (List<Integer> partition : input) {
            int primary = partition.remove(0);
            int[] replicas = new int[partition.size()];
            int i = 0;
            for (int replica : partition) {
                replicas[i++] = replica;
            }
            partitions.add(new DefaultPartition(primary, replicas));
        }
        return partitions;
    }

    public String toString() {
        return "PartitionInfo{numberOfReplicas=" + this.numberOfReplicas + ", partitionHosts=" + Arrays.toString(this.partitionHosts) + ", partitions=" + this.partitions + ", tainted=" + this.tainted + '}';
    }
}

