/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.config;

import com.couchbase.client.dcp.core.config.AlternateAddress;
import com.couchbase.client.dcp.core.config.PortInfo;
import com.couchbase.client.dcp.core.service.ServiceType;
import com.couchbase.client.dcp.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.dcp.deps.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DefaultPortInfo
implements PortInfo {
    private final Map<ServiceType, Integer> ports = new HashMap<ServiceType, Integer>();
    private final Map<ServiceType, Integer> sslPorts = new HashMap<ServiceType, Integer>();
    private final Map<String, AlternateAddress> alternateAddresses;
    private final String hostname;

    @JsonCreator
    public DefaultPortInfo(@JsonProperty(value="services") Map<String, Integer> services, @JsonProperty(value="hostname") String hostname, @JsonProperty(value="alternateAddresses") Map<String, AlternateAddress> aa) {
        this.alternateAddresses = aa == null ? Collections.emptyMap() : aa;
        this.hostname = hostname;
        DefaultPortInfo.extractPorts(services, this.ports, this.sslPorts);
    }

    static void extractPorts(Map<String, Integer> input, Map<ServiceType, Integer> ports, Map<ServiceType, Integer> sslPorts) {
        for (Map.Entry<String, Integer> entry : input.entrySet()) {
            String service = entry.getKey();
            int port = entry.getValue();
            if (service.equals("mgmt")) {
                ports.put(ServiceType.CONFIG, port);
                continue;
            }
            if (service.equals("capi")) {
                ports.put(ServiceType.VIEW, port);
                continue;
            }
            if (service.equals("kv")) {
                ports.put(ServiceType.BINARY, port);
                continue;
            }
            if (service.equals("kvSSL")) {
                sslPorts.put(ServiceType.BINARY, port);
                continue;
            }
            if (service.equals("capiSSL")) {
                sslPorts.put(ServiceType.VIEW, port);
                continue;
            }
            if (service.equals("mgmtSSL")) {
                sslPorts.put(ServiceType.CONFIG, port);
                continue;
            }
            if (service.equals("n1ql")) {
                ports.put(ServiceType.QUERY, port);
                continue;
            }
            if (service.equals("n1qlSSL")) {
                sslPorts.put(ServiceType.QUERY, port);
                continue;
            }
            if (service.equals("fts")) {
                ports.put(ServiceType.SEARCH, port);
                continue;
            }
            if (service.equals("ftsSSL")) {
                sslPorts.put(ServiceType.SEARCH, port);
                continue;
            }
            if (service.equals("cbas")) {
                ports.put(ServiceType.ANALYTICS, port);
                continue;
            }
            if (!service.equals("cbasSSL")) continue;
            sslPorts.put(ServiceType.ANALYTICS, port);
        }
    }

    @Override
    public Map<ServiceType, Integer> ports() {
        return this.ports;
    }

    @Override
    public Map<ServiceType, Integer> sslPorts() {
        return this.sslPorts;
    }

    @Override
    public String hostname() {
        return this.hostname;
    }

    @Override
    public Map<String, AlternateAddress> alternateAddresses() {
        return this.alternateAddresses;
    }

    public String toString() {
        return "DefaultPortInfo{ports=" + this.ports + ", sslPorts=" + this.sslPorts + ", hostname='" + this.hostname + ", alternateAddresses=" + this.alternateAddresses + '\'' + '}';
    }
}

