/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CbCollections {
    private CbCollections() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static <T> List<T> copyToUnmodifiableList(Collection<T> c) {
        return CbCollections.isNullOrEmpty(c) ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<T>(c));
    }

    public static <T> Set<T> copyToUnmodifiableSet(Collection<T> c) {
        return CbCollections.isNullOrEmpty(c) ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<T>(c));
    }

    public static boolean isNullOrEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static boolean isNullOrEmpty(Map<?, ?> m) {
        return m == null || m.isEmpty();
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    @SafeVarargs
    public static <T> Set<T> setOf(T ... items) {
        HashSet<T> result = new HashSet<T>();
        for (T item : items) {
            if (result.add(Objects.requireNonNull(item, "Set may not contain null"))) continue;
            throw new IllegalArgumentException("Duplicate item: " + item);
        }
        return Collections.unmodifiableSet(result);
    }

    @SafeVarargs
    public static <T> List<T> listOf(T ... items) {
        ArrayList<T> result = new ArrayList<T>(items.length);
        for (T item : items) {
            result.add(Objects.requireNonNull(item, "List may not contain null"));
        }
        return Collections.unmodifiableList(result);
    }

    public static <K, V> Map<K, V> mapOf() {
        return Collections.emptyMap();
    }

    public static <K, V> Map<K, V> mapOf(K key1, V value1) {
        HashMap result = new HashMap();
        CbCollections.putUniqueKey(result, key1, value1);
        return Collections.unmodifiableMap(result);
    }

    public static <K, V> Map<K, V> mapOf(K key1, V value1, K key2, V value2) {
        HashMap result = new HashMap();
        CbCollections.putUniqueKey(result, key1, value1);
        CbCollections.putUniqueKey(result, key2, value2);
        return Collections.unmodifiableMap(result);
    }

    public static <K, V> Map<K, V> mapOf(K key1, V value1, K key2, V value2, K key3, V value3) {
        HashMap result = new HashMap();
        CbCollections.putUniqueKey(result, key1, value1);
        CbCollections.putUniqueKey(result, key2, value2);
        CbCollections.putUniqueKey(result, key3, value3);
        return Collections.unmodifiableMap(result);
    }

    public static <K, V> Map<K, V> mapOf(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        HashMap result = new HashMap();
        CbCollections.putUniqueKey(result, key1, value1);
        CbCollections.putUniqueKey(result, key2, value2);
        CbCollections.putUniqueKey(result, key3, value3);
        CbCollections.putUniqueKey(result, key4, value4);
        return Collections.unmodifiableMap(result);
    }

    public static <K, V> Map<K, V> mapOf(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4, K key5, V value5) {
        HashMap result = new HashMap();
        CbCollections.putUniqueKey(result, key1, value1);
        CbCollections.putUniqueKey(result, key2, value2);
        CbCollections.putUniqueKey(result, key3, value3);
        CbCollections.putUniqueKey(result, key4, value4);
        CbCollections.putUniqueKey(result, key5, value5);
        return Collections.unmodifiableMap(result);
    }

    private static <K, V> void putUniqueKey(Map<K, V> map, K key, V value) {
        Objects.requireNonNull(key, "Key may not be null.");
        Objects.requireNonNull(value, "Value may not be null.");
        if (map.put(key, value) != null) {
            throw new IllegalArgumentException("Duplicate key: " + key);
        }
    }
}

