/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.deps.io.netty.handler.codec.mqtt;

import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.deps.io.netty.handler.codec.DecoderResult;
import com.couchbase.client.dcp.deps.io.netty.handler.codec.mqtt.MqttConnAckMessage;
import com.couchbase.client.dcp.deps.io.netty.handler.codec.mqtt.MqttConnAckVariableHeader;
import com.couchbase.client.dcp.deps.io.netty.handler.codec.mqtt.MqttConnectMessage;
import com.couchbase.client.dcp.deps.io.netty.handler.codec.mqtt.MqttConnectPayload;
import com.couchbase.client.dcp.deps.io.netty.handler.codec.mqtt.MqttConnectVariableHeader;
import com.couchbase.client.dcp.deps.io.netty.handler.codec.mqtt.MqttFixedHeader;
import com.couchbase.client.dcp.deps.io.netty.handler.codec.mqtt.MqttMessage;
import com.couchbase.client.dcp.deps.io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import com.couchbase.client.dcp.deps.io.netty.handler.codec.mqtt.MqttPubAckMessage;
import com.couchbase.client.dcp.deps.io.netty.handler.codec.mqtt.MqttPublishMessage;
import com.couchbase.client.dcp.deps.io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import com.couchbase.client.dcp.deps.io.netty.handler.codec.mqtt.MqttSubAckMessage;
import com.couchbase.client.dcp.deps.io.netty.handler.codec.mqtt.MqttSubAckPayload;
import com.couchbase.client.dcp.deps.io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import com.couchbase.client.dcp.deps.io.netty.handler.codec.mqtt.MqttSubscribePayload;
import com.couchbase.client.dcp.deps.io.netty.handler.codec.mqtt.MqttUnsubAckMessage;
import com.couchbase.client.dcp.deps.io.netty.handler.codec.mqtt.MqttUnsubAckPayload;
import com.couchbase.client.dcp.deps.io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import com.couchbase.client.dcp.deps.io.netty.handler.codec.mqtt.MqttUnsubscribePayload;

public final class MqttMessageFactory {
    public static MqttMessage newMessage(MqttFixedHeader mqttFixedHeader, Object variableHeader, Object payload) {
        switch (mqttFixedHeader.messageType()) {
            case CONNECT: {
                return new MqttConnectMessage(mqttFixedHeader, (MqttConnectVariableHeader)variableHeader, (MqttConnectPayload)payload);
            }
            case CONNACK: {
                return new MqttConnAckMessage(mqttFixedHeader, (MqttConnAckVariableHeader)variableHeader);
            }
            case SUBSCRIBE: {
                return new MqttSubscribeMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader, (MqttSubscribePayload)payload);
            }
            case SUBACK: {
                return new MqttSubAckMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader, (MqttSubAckPayload)payload);
            }
            case UNSUBACK: {
                return new MqttUnsubAckMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader, (MqttUnsubAckPayload)payload);
            }
            case UNSUBSCRIBE: {
                return new MqttUnsubscribeMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader, (MqttUnsubscribePayload)payload);
            }
            case PUBLISH: {
                return new MqttPublishMessage(mqttFixedHeader, (MqttPublishVariableHeader)variableHeader, (ByteBuf)payload);
            }
            case PUBACK: {
                return new MqttPubAckMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader);
            }
            case PUBREC: 
            case PUBREL: 
            case PUBCOMP: {
                return new MqttMessage(mqttFixedHeader, variableHeader);
            }
            case PINGREQ: 
            case PINGRESP: {
                return new MqttMessage(mqttFixedHeader);
            }
            case DISCONNECT: 
            case AUTH: {
                return new MqttMessage(mqttFixedHeader, variableHeader);
            }
        }
        throw new IllegalArgumentException("unknown message type: " + (Object)((Object)mqttFixedHeader.messageType()));
    }

    public static MqttMessage newInvalidMessage(Throwable cause) {
        return new MqttMessage(null, null, null, DecoderResult.failure(cause));
    }

    public static MqttMessage newInvalidMessage(MqttFixedHeader mqttFixedHeader, Object variableHeader, Throwable cause) {
        return new MqttMessage(mqttFixedHeader, variableHeader, null, DecoderResult.failure(cause));
    }

    private MqttMessageFactory() {
    }
}

