/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.highlevel;

import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.highlevel.DatabaseChangeListener;
import com.couchbase.client.dcp.highlevel.internal.CollectionsManifest;
import com.couchbase.client.dcp.highlevel.internal.DatabaseChangeEvent;
import com.couchbase.client.dcp.message.DcpSystemEvent;
import com.couchbase.client.dcp.message.MessageUtil;

public class ScopeDropped
extends DcpSystemEvent
implements DcpSystemEvent.CollectionsManifestEvent,
DatabaseChangeEvent {
    private final long newManifestId;
    private final long scopeId;

    public ScopeDropped(int vbucket, long seqno, int version, ByteBuf buffer) {
        super(DcpSystemEvent.Type.SCOPE_DROPPED, vbucket, seqno, version);
        ByteBuf value = MessageUtil.getContent(buffer);
        this.newManifestId = value.readLong();
        this.scopeId = value.readUnsignedInt();
    }

    @Override
    public long getManifestId() {
        return this.newManifestId;
    }

    public long getScopeId() {
        return this.scopeId;
    }

    @Override
    public CollectionsManifest apply(CollectionsManifest currentManifest) {
        return currentManifest.withoutScope(this.newManifestId, this.scopeId);
    }

    @Override
    public void dispatch(DatabaseChangeListener listener) {
        listener.onScopeDropped(this);
    }

    public String toString() {
        return "ScopeDropped{newManifestId=" + this.newManifestId + ", scopeId=" + this.scopeId + ", vbucket=" + this.getVbucket() + ", seqno=" + this.getSeqno() + ", version=" + this.getVersion() + '}';
    }
}

