/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.highlevel.internal;

import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.dcp.transport.netty.ChannelFlowController;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public class FlowControlReceipt {
    private final ChannelFlowController flowController;
    private final int ackByteCount;
    private final AtomicBoolean acknowledged = new AtomicBoolean();
    private static final FlowControlReceipt dummy = new FlowControlReceipt(ChannelFlowController.dummy, 0){

        @Override
        public void acknowledge() {
        }
    };

    public FlowControlReceipt(ChannelFlowController flowController, int ackByteCount) {
        this.flowController = Objects.requireNonNull(flowController);
        this.ackByteCount = ackByteCount;
    }

    public void acknowledge() {
        if (this.acknowledged.compareAndSet(false, true)) {
            this.flowController.ack(this.ackByteCount);
        }
    }

    public static FlowControlReceipt forMessage(ChannelFlowController flowController, ByteBuf message) {
        return MessageUtil.requiresFlowControlAck(message) ? new FlowControlReceipt(flowController, message.readableBytes()) : dummy;
    }
}

