/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.message;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

public enum DataType {
    JSON(1),
    SNAPPY(2),
    XATTR(4);

    private final int bitmask;
    private static final List<DataType> values;

    private DataType(int bitmask) {
        this.bitmask = bitmask;
    }

    public int bitmask() {
        return this.bitmask;
    }

    public static EnumSet<DataType> parse(int bitfield) {
        EnumSet<DataType> result = EnumSet.noneOf(DataType.class);
        for (DataType type : values) {
            if (!DataType.contains(bitfield, type)) continue;
            result.add(type);
        }
        return result;
    }

    public static boolean contains(int bitfield, DataType type) {
        return (bitfield & type.bitmask()) != 0;
    }

    static {
        values = Collections.unmodifiableList(Arrays.asList(DataType.values()));
    }
}

