/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.message;

import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.message.MessageUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class DcpMutationMessage
extends Enum<DcpMutationMessage> {
    private static final /* synthetic */ DcpMutationMessage[] $VALUES;

    public static DcpMutationMessage[] values() {
        return (DcpMutationMessage[])$VALUES.clone();
    }

    public static DcpMutationMessage valueOf(String name) {
        return Enum.valueOf(DcpMutationMessage.class, name);
    }

    public static boolean is(ByteBuf buffer) {
        return buffer.getByte(0) == -128 && buffer.getByte(1) == 87;
    }

    @Deprecated
    public static ByteBuf key(ByteBuf buffer) {
        return MessageUtil.getKey(buffer);
    }

    @Deprecated
    public static String keyString(ByteBuf buffer, Charset charset) {
        return DcpMutationMessage.key(buffer).toString(charset);
    }

    @Deprecated
    public static String keyString(ByteBuf buffer) {
        return DcpMutationMessage.keyString(buffer, StandardCharsets.UTF_8);
    }

    public static ByteBuf content(ByteBuf buffer) {
        return MessageUtil.getContent(buffer);
    }

    public static byte[] contentBytes(ByteBuf buffer) {
        return MessageUtil.getContentAsByteArray(buffer);
    }

    public static long cas(ByteBuf buffer) {
        return MessageUtil.getCas(buffer);
    }

    public static int partition(ByteBuf buffer) {
        return MessageUtil.getVbucket(buffer);
    }

    public static long bySeqno(ByteBuf buffer) {
        return buffer.getLong(24);
    }

    public static long revisionSeqno(ByteBuf buffer) {
        return buffer.getLong(32);
    }

    public static int flags(ByteBuf buffer) {
        return buffer.getInt(40);
    }

    public static int expiry(ByteBuf buffer) {
        return buffer.getInt(44);
    }

    public static int lockTime(ByteBuf buffer) {
        return buffer.getInt(48);
    }

    public static String toString(ByteBuf buffer) {
        return "MutationMessage [key: \"" + DcpMutationMessage.keyString(buffer) + "\", vbid: " + DcpMutationMessage.partition(buffer) + ", cas: " + DcpMutationMessage.cas(buffer) + ", bySeqno: " + DcpMutationMessage.bySeqno(buffer) + ", revSeqno: " + DcpMutationMessage.revisionSeqno(buffer) + ", flags: " + DcpMutationMessage.flags(buffer) + ", expiry: " + DcpMutationMessage.expiry(buffer) + ", lockTime: " + DcpMutationMessage.lockTime(buffer) + ", clength: " + DcpMutationMessage.content(buffer).readableBytes() + "]";
    }

    private static /* synthetic */ DcpMutationMessage[] $values() {
        return new DcpMutationMessage[0];
    }

    static {
        $VALUES = DcpMutationMessage.$values();
    }
}

