/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.message;

import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.dcp.message.HelloFeature;
import com.couchbase.client.dcp.message.MessageUtil;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public final class HelloRequest
extends Enum<HelloRequest> {
    private static final Set<HelloFeature> standardFeatures;
    private static final /* synthetic */ HelloRequest[] $VALUES;

    public static HelloRequest[] values() {
        return (HelloRequest[])$VALUES.clone();
    }

    public static HelloRequest valueOf(String name) {
        return Enum.valueOf(HelloRequest.class, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(ByteBuf buffer, String connectionName, Set<HelloFeature> extraFeatures) {
        MessageUtil.initRequest((byte)31, buffer);
        MessageUtil.setKey(connectionName, buffer);
        EnumSet<HelloFeature> advertisedFeatures = EnumSet.copyOf(standardFeatures);
        advertisedFeatures.addAll(extraFeatures);
        ByteBuf features = Unpooled.buffer(advertisedFeatures.size() * 2);
        try {
            for (HelloFeature feature : advertisedFeatures) {
                features.writeShort(feature.code());
            }
            MessageUtil.setContent(features, buffer);
        }
        finally {
            features.release();
        }
    }

    public static Set<HelloFeature> parseResponse(ByteBuf msg) {
        EnumSet<HelloFeature> features = EnumSet.noneOf(HelloFeature.class);
        ByteBuf content = MessageUtil.getContent(msg);
        while (content.isReadable()) {
            features.add(HelloFeature.forCode(content.readShort()));
        }
        return features;
    }

    private static /* synthetic */ HelloRequest[] $values() {
        return new HelloRequest[0];
    }

    static {
        $VALUES = HelloRequest.$values();
        standardFeatures = Collections.unmodifiableSet(EnumSet.of(HelloFeature.XATTR, HelloFeature.XERROR, HelloFeature.SELECT_BUCKET, HelloFeature.DUPLEX, HelloFeature.CLUSTERMAP_CHANGE_NOTIFICATION));
    }
}

