/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.transport.netty;

import com.couchbase.client.dcp.Authenticator;
import com.couchbase.client.dcp.SecurityConfig;
import com.couchbase.client.dcp.config.HostAndPort;
import com.couchbase.client.dcp.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.dcp.deps.io.netty.handler.ssl.OpenSsl;
import com.couchbase.client.dcp.deps.io.netty.handler.ssl.SslContextBuilder;
import com.couchbase.client.dcp.deps.io.netty.handler.ssl.SslHandler;
import com.couchbase.client.dcp.deps.io.netty.handler.ssl.SslProvider;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public class SslHandlerFactory {
    private SslHandlerFactory() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static SslHandler get(ByteBufAllocator allocator, SecurityConfig config, HostAndPort peer, Authenticator authenticator) throws Exception {
        SslProvider provider = OpenSsl.isAvailable() && config.nativeTlsEnabled() ? SslProvider.OPENSSL : SslProvider.JDK;
        SslContextBuilder context = SslContextBuilder.forClient().sslProvider(provider);
        if (config.trustManagerFactory() != null) {
            context.trustManager(config.trustManagerFactory());
        } else if (config.trustCertificates() != null && !config.trustCertificates().isEmpty()) {
            context.trustManager(config.trustCertificates().toArray(new X509Certificate[0]));
        }
        authenticator.applyTlsProperties(context);
        SslHandler sslHandler = context.build().newHandler(allocator, peer.host(), peer.port());
        SSLEngine sslEngine = sslHandler.engine();
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        if (config.hostnameVerificationEnabled()) {
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
        }
        sslEngine.setSSLParameters(sslParameters);
        return sslHandler;
    }
}

