/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.config;

import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Comparator;
import java.util.Objects;

public class ConfigRevision
implements Comparable<ConfigRevision> {
    private static final Comparator<ConfigRevision> comparator = Comparator.comparing(ConfigRevision::epoch).thenComparing(ConfigRevision::rev);
    private final long epoch;
    private final long rev;

    public static ConfigRevision parse(ObjectNode json) {
        int epoch = json.path("epoch").intValue();
        JsonNode revNode = json.path("rev");
        if (!revNode.isInt()) {
            throw new IllegalArgumentException("Missing or non-integer 'rev' field.");
        }
        return new ConfigRevision(epoch, revNode.intValue());
    }

    public ConfigRevision(long epoch, long rev) {
        this.epoch = epoch;
        this.rev = rev;
    }

    public long epoch() {
        return this.epoch;
    }

    public long rev() {
        return this.rev;
    }

    @Override
    public int compareTo(ConfigRevision o) {
        return comparator.compare(this, o);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigRevision that = (ConfigRevision)o;
        return this.epoch == that.epoch && this.rev == that.rev;
    }

    public String toString() {
        return this.epoch + "." + this.rev;
    }

    public int hashCode() {
        return Objects.hash(this.epoch, this.rev);
    }

    public boolean newerThan(ConfigRevision other) {
        return this.compareTo(other) > 0;
    }
}

